/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.nbt.path;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.cyclops.cyclopscore.nbt.path.INbtPathExpression;
import org.cyclops.cyclopscore.nbt.path.NbtParseException;
import org.cyclops.cyclopscore.nbt.path.NbtPathExpressionList;
import org.cyclops.cyclopscore.nbt.path.parse.INbtPathExpressionParseHandler;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerAllChildren;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerBooleanRelationalEqual;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerBooleanRelationalGreaterThan;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerBooleanRelationalGreaterThanOrEqual;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerBooleanRelationalLessThan;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerBooleanRelationalLessThanOrEqual;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerChild;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerChildBrackets;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerCurrent;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerFilterExpression;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerLength;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerListElement;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerListSlice;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerParent;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerRoot;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerStringEqual;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerUnion;

public class NbtPath {
    private static final List<INbtPathExpressionParseHandler> PARSE_HANDLERS = Lists.newArrayList((Object[])new INbtPathExpressionParseHandler[]{new NbtPathExpressionParseHandlerRoot(), new NbtPathExpressionParseHandlerLength(), new NbtPathExpressionParseHandlerChild(), new NbtPathExpressionParseHandlerChildBrackets(), new NbtPathExpressionParseHandlerParent(), new NbtPathExpressionParseHandlerAllChildren(), new NbtPathExpressionParseHandlerCurrent(), new NbtPathExpressionParseHandlerListElement(), new NbtPathExpressionParseHandlerListSlice(), new NbtPathExpressionParseHandlerUnion(), new NbtPathExpressionParseHandlerBooleanRelationalLessThan(), new NbtPathExpressionParseHandlerBooleanRelationalLessThanOrEqual(), new NbtPathExpressionParseHandlerBooleanRelationalGreaterThan(), new NbtPathExpressionParseHandlerBooleanRelationalGreaterThanOrEqual(), new NbtPathExpressionParseHandlerBooleanRelationalEqual(), new NbtPathExpressionParseHandlerStringEqual(), new NbtPathExpressionParseHandlerFilterExpression()});

    public static INbtPathExpression parse(String nbtPathExpression) throws NbtParseException {
        ArrayList expressions = Lists.newArrayList();
        int pos = 0;
        while (pos < nbtPathExpression.length()) {
            boolean handled = false;
            for (INbtPathExpressionParseHandler parseHandler : PARSE_HANDLERS) {
                INbtPathExpressionParseHandler.HandleResult handleResult = parseHandler.handlePrefixOf(nbtPathExpression, pos);
                if (!handleResult.isValid()) continue;
                pos += handleResult.getConsumedExpressionLength();
                expressions.add(handleResult.getPrefixExpression());
                handled = true;
                break;
            }
            if (handled) continue;
            throw new NbtParseException(String.format("Failed to parse expression at pos '%s'", pos, nbtPathExpression));
        }
        return new NbtPathExpressionList(expressions.toArray(new INbtPathExpression[0]));
    }
}

