/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.button;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.gui.widget.button.Button;
import org.cyclops.cyclopscore.helper.RenderHelpers;

public abstract class ButtonExtended
extends Button {
    private final boolean background;

    public ButtonExtended(int x, int y, int width, int height, String narrationMessage, Button.IPressable pressCallback, boolean background) {
        super(x, y, width, height, narrationMessage, pressCallback);
        this.background = background;
    }

    protected void drawBackground() {
        RenderHelpers.bindTexture(WIDGETS_LOCATION);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int hoverState = this.getYImage(this.isHovered());
        this.blit(this.x, this.y, 0, 46 + hoverState * 20, this.width / 2, this.height / 2);
        this.blit(this.x + this.width / 2, this.y, 200 - this.width / 2, 46 + hoverState * 20, this.width / 2, this.height / 2);
        this.blit(this.x, this.y + this.height / 2, 0, 46 + hoverState * 20 + 20 - this.height / 2, this.width / 2, this.height / 2);
        this.blit(this.x + this.width / 2, this.y + this.height / 2, 200 - this.width / 2, 46 + hoverState * 20 + 20 - this.height / 2, this.width / 2, this.height / 2);
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            if (this.background) {
                this.drawBackground();
            }
            this.drawButtonInner(mouseX, mouseY);
        }
    }

    protected abstract void drawButtonInner(int var1, int var2);
}

