/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.container;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;

public abstract class ContainerScreenScrolling<T extends ScrollingInventoryContainer>
extends ContainerScreenExtended<T> {
    private static final int SEARCH_WIDTH = 89;
    private WidgetTextFieldExtended searchField = null;
    private WidgetScrollBar scrollbar = null;

    public ContainerScreenScrolling(T container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
    }

    @Override
    public void init() {
        super.init();
        this.minecraft.field_195559_v.func_197967_a(true);
        boolean resetFilter = false;
        if (this.isSearchEnabled()) {
            int searchWidth = this.getSearchWidth();
            int searchX = this.getSearchX();
            int searchY = this.getSearchY();
            if (this.searchField == null) {
                resetFilter = true;
                this.font.getClass();
                this.searchField = new WidgetTextFieldExtended(this.font, this.field_147003_i + searchX, this.field_147009_r + searchY, searchWidth, 9, L10NHelpers.localize("gui.cyclopscore.search", new Object[0]));
                this.searchField.func_146203_f(64);
                this.searchField.func_146203_f(15);
                this.searchField.func_146185_a(false);
                this.searchField.func_146189_e(true);
                this.searchField.func_146193_g(0xFFFFFF);
                this.searchField.func_146205_d(true);
                this.searchField.func_146180_a("");
                this.searchField.setWidth(searchWidth);
                this.searchField.x = this.field_147003_i + (searchX + searchWidth) - this.searchField.getWidth();
            } else {
                this.searchField.setWidth(searchWidth);
                this.searchField.x = this.field_147003_i + (searchX + searchWidth) - this.searchField.getWidth();
                this.searchField.y = this.field_147009_r + searchY;
            }
            this.children.add(this.searchField);
        }
        if (this.scrollbar == null) {
            this.scrollbar = new WidgetScrollBar(this.field_147003_i + this.getScrollX(), this.field_147009_r + this.getScrollY(), this.getScrollHeight(), L10NHelpers.localize("gui.cyclopscore.scrollbar", new Object[0]), (WidgetScrollBar.IScrollCallback)this.func_212873_a_(), ((ScrollingInventoryContainer)this.func_212873_a_()).getPageSize());
            this.scrollbar.setTotalRows(((ScrollingInventoryContainer)this.func_212873_a_()).getFilteredItemCount() / ((ScrollingInventoryContainer)this.func_212873_a_()).getColumns());
        }
        this.children.add(this.scrollbar);
        if (resetFilter) {
            ((ScrollingInventoryContainer)this.func_212873_a_()).updateFilter("");
        }
        this.getScrollbar().scrollTo(this.scrollbar.getCurrentScroll());
    }

    public void onClose() {
        super.onClose();
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.isSearchEnabled() && this.searchField.charTyped(typedChar, keyCode)) {
            this.updateSearch(this.searchField.func_146179_b());
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    @Override
    protected void drawCurrentScreen(int mouseX, int mouseY, float partialTicks) {
        if (this.isSubsetRenderSlots()) {
            ArrayList oldSlots = Lists.newArrayList((Iterable)((ScrollingInventoryContainer)this.field_147002_h).field_75151_b);
            int startIndex = ((ScrollingInventoryContainer)this.func_212873_a_()).getFirstElement();
            ArrayList newSlots = Lists.newArrayList();
            newSlots.addAll(oldSlots.subList(startIndex, Math.min(oldSlots.size(), startIndex + ((ScrollingInventoryContainer)this.func_212873_a_()).getPageSize() * ((ScrollingInventoryContainer)this.func_212873_a_()).getColumns())));
            newSlots.addAll(oldSlots.subList(((ScrollingInventoryContainer)this.func_212873_a_()).getUnfilteredItemCount(), oldSlots.size()));
            ((ScrollingInventoryContainer)this.field_147002_h).field_75151_b.clear();
            ((ScrollingInventoryContainer)this.field_147002_h).field_75151_b.addAll(newSlots);
            super.drawCurrentScreen(mouseX, mouseY, partialTicks);
            ((ScrollingInventoryContainer)this.field_147002_h).field_75151_b.clear();
            ((ScrollingInventoryContainer)this.field_147002_h).field_75151_b.addAll(oldSlots);
        } else {
            super.drawCurrentScreen(mouseX, mouseY, partialTicks);
        }
    }

    protected boolean isSubsetRenderSlots() {
        return false;
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        if (this.isSearchEnabled()) {
            this.searchField.render(mouseX, mouseY, partialTicks);
        }
        this.scrollbar.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        if (this.getFocused() != null && this.isDragging() && mouseButton == 0 && this.getFocused().mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    protected void updateSearch(String searchString) {
        this.scrollbar.scrollTo(0.0f);
        ((ScrollingInventoryContainer)this.func_212873_a_()).updateFilter(searchString);
    }

    public TextFieldWidget getSearchField() {
        return this.searchField;
    }

    public WidgetScrollBar getScrollbar() {
        return this.scrollbar;
    }

    protected int getScrollX() {
        return 175;
    }

    protected int getScrollY() {
        return 18;
    }

    protected int getScrollHeight() {
        return 112;
    }

    protected boolean isSearchEnabled() {
        return true;
    }

    protected int getSearchX() {
        return 82;
    }

    protected int getSearchY() {
        return 6;
    }

    protected int getSearchWidth() {
        return 89;
    }
}

