/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.particle;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ParticleBlur
extends Particle {
    private static final Queue<ParticleBlur> BLURS_PENDING_RENDER = Queues.newLinkedBlockingDeque();
    private static final ResourceLocation TEXTURE = new ResourceLocation("cyclopscore", "textures/particles/particle_blur.png");
    private static final int MAX_VIEW_DISTANCE = 30;
    private float scaleLife;
    private float originalScale;
    private float f;
    private float f1;
    private float f2;
    private float f3;
    private float f4;
    private float f5;

    public ParticleBlur(ParticleBlurData data, World world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.field_187129_i = motionX;
        this.field_187130_j = motionY;
        this.field_187131_k = motionZ;
        this.field_70552_h = data.getRed();
        this.field_70553_i = data.getGreen();
        this.field_70551_j = data.getBlue();
        this.field_82339_as = 0.9f;
        this.field_70545_g = 0.0f;
        this.originalScale = (this.field_187136_p.nextFloat() * 0.5f + 0.5f) * 2.0f * data.getScale();
        this.field_70547_e = (int)((this.field_187136_p.nextFloat() * 0.33f + 0.66f) * data.getAgeMultiplier());
        this.func_187115_a(0.01f, 0.01f);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.scaleLife = (float)((double)this.field_70547_e / 2.5);
        this.validateDistance();
    }

    private void validateDistance() {
        ClientPlayerEntity renderentity = Minecraft.func_71410_x().field_71439_g;
        int visibleDistance = 30;
        if (!Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            visibleDistance /= 2;
        }
        if (renderentity == null || renderentity.func_70092_e(this.field_187126_f, this.field_187127_g, this.field_187128_h) > (double)(visibleDistance * visibleDistance)) {
            this.field_70547_e = 0;
        }
    }

    public void func_180434_a(BufferBuilder worldRenderer, ActiveRenderInfo renderInfo, float f, float f1, float f2, float f3, float f4, float f5) {
        this.f = f;
        this.f1 = f1;
        this.f2 = f2;
        this.f3 = f3;
        this.f4 = f4;
        this.f5 = f5;
        BLURS_PENDING_RENDER.add(this);
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217605_e;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187130_j -= 0.04 * (double)this.field_70545_g;
        this.field_187126_f += this.field_187129_i;
        this.field_187127_g += this.field_187130_j;
        this.field_187128_h += this.field_187131_k;
        this.field_187129_i *= (double)0.98f;
        this.field_187130_j *= (double)0.98f;
        this.field_187131_k *= (double)0.98f;
    }

    public void setGravity(float particleGravity) {
        this.field_70545_g = particleGravity;
    }

    private void renderQueued(BufferBuilder worldRenderer) {
        float agescale = (float)this.field_70546_d / this.scaleLife;
        if (agescale > 1.0f) {
            agescale = 2.0f - agescale;
        }
        float currentScale = this.originalScale * agescale;
        float f10 = 0.5f * currentScale;
        float f11 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)this.f - field_70556_an);
        float f12 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)this.f - field_70554_ao);
        float f13 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)this.f - field_70555_ap);
        int i = this.func_189214_a(this.f5);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        worldRenderer.func_181662_b((double)(f11 - this.f1 * f10 - this.f4 * f10), (double)(f12 - this.f2 * f10), (double)(f13 - this.f3 * f10 - this.f5 * f10)).func_187315_a(0.0, 1.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 0.9f).func_187314_a(j, k).func_181675_d();
        worldRenderer.func_181662_b((double)(f11 - this.f1 * f10 + this.f4 * f10), (double)(f12 + this.f2 * f10), (double)(f13 - this.f3 * f10 + this.f5 * f10)).func_187315_a(1.0, 1.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 0.9f).func_187314_a(j, k).func_181675_d();
        worldRenderer.func_181662_b((double)(f11 + this.f1 * f10 + this.f4 * f10), (double)(f12 + this.f2 * f10), (double)(f13 + this.f3 * f10 + this.f5 * f10)).func_187315_a(1.0, 0.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 0.9f).func_187314_a(j, k).func_181675_d();
        worldRenderer.func_181662_b((double)(f11 + this.f1 * f10 - this.f4 * f10), (double)(f12 - this.f2 * f10), (double)(f13 + this.f3 * f10 - this.f5 * f10)).func_187315_a(0.0, 0.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 0.9f).func_187314_a(j, k).func_181675_d();
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        if (!BLURS_PENDING_RENDER.isEmpty()) {
            ParticleBlur particleBlur;
            GlStateManager.pushMatrix();
            GL11.glPushAttrib((int)64);
            GlStateManager.depthMask((boolean)false);
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)1);
            GlStateManager.disableLighting();
            RenderHelpers.bindTexture(TEXTURE);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            BufferBuilder worldRenderer = Tessellator.func_178181_a().func_178180_c();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            while ((particleBlur = BLURS_PENDING_RENDER.poll()) != null) {
                particleBlur.renderQueued(worldRenderer);
            }
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.disableBlend();
            GlStateManager.depthMask((boolean)true);
            GlStateManager.blendFunc((int)770, (int)771);
            GlStateManager.popMatrix();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopAttrib();
        }
    }
}

