/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.render.tileentity;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;

public abstract class RenderTileEntityModel<T extends CyclopsTileEntity, M>
extends TileEntityRenderer<T> {
    protected final M model;
    private final ResourceLocation texture;

    public RenderTileEntityModel(M model, ResourceLocation texture) {
        this.model = model;
        this.texture = texture;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    protected void preRotate(T tile) {
        GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    protected void postRotate(T tile) {
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
    }

    public void render(T tile, double x, double y, double z, float partialTick, int destroyStage) {
        Direction direction = ((CyclopsTileEntity)tile).getRotation();
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.matrixMode((int)5888);
        } else if (this.getTexture() != null) {
            this.func_147499_a(this.getTexture());
        }
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        this.preRotate(tile);
        int rotation = 0;
        if (direction == Direction.SOUTH) {
            rotation = 180;
        }
        if (direction == Direction.NORTH) {
            rotation = 0;
        }
        if (direction == Direction.EAST) {
            rotation = 90;
        }
        if (direction == Direction.WEST) {
            rotation = -90;
        }
        GlStateManager.rotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        this.postRotate(tile);
        this.renderModel(tile, this.getModel(), partialTick, destroyStage);
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
    }

    protected abstract void renderModel(T var1, M var2, float var3, int var4);

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenderTileEntityModel)) {
            return false;
        }
        RenderTileEntityModel other = (RenderTileEntityModel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        M this$model = this.getModel();
        M other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        ResourceLocation this$texture = this.getTexture();
        ResourceLocation other$texture = other.getTexture();
        return !(this$texture == null ? other$texture != null : !this$texture.equals(other$texture));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RenderTileEntityModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        M $model = this.getModel();
        result = result * 59 + ($model == null ? 0 : $model.hashCode());
        ResourceLocation $texture = this.getTexture();
        result = result * 59 + ($texture == null ? 0 : $texture.hashCode());
        return result;
    }

    public M getModel() {
        return this.model;
    }

    public String toString() {
        return "RenderTileEntityModel(model=" + this.getModel() + ", texture=" + this.getTexture() + ")";
    }
}

