/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigForge;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class EntityConfig<T extends Entity>
extends ExtendedConfigForge<EntityConfig<T>, EntityType<T>> {
    private final Class<? extends T> entityClass;

    public EntityConfig(ModBase mod, String namedId, Function<EntityConfig<T>, ? extends EntityType<T>> elementConstructor, Class<? extends T> entityClass) {
        super(mod, namedId, elementConstructor);
        this.entityClass = entityClass;
    }

    @Override
    public String getTranslationKey() {
        return "entity." + this.getNamedId();
    }

    @Override
    public ConfigurableType getConfigurableType() {
        return ConfigurableType.ENTITY;
    }

    public Class<? extends T> getEntityClass() {
        return this.entityClass;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRegistered() {
        super.onRegistered();
        Class<T> clazz = this.getEntityClass();
        RenderingRegistry.registerEntityRenderingHandler(clazz, manager -> this.getRender(manager, Minecraft.func_71410_x().func_175599_af()));
    }

    public int getTrackingRange() {
        return 160;
    }

    public int getUpdateFrequency() {
        return 10;
    }

    public boolean sendVelocityUpdates() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract EntityRenderer<? super T> getRender(EntityRendererManager var1, ItemRenderer var2);

    @Override
    public IForgeRegistry<EntityType<?>> getRegistry() {
        return ForgeRegistries.ENTITIES;
    }
}

