/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.datastructure;

import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class DimPos
implements Comparable<DimPos> {
    private final DimensionType dimension;
    private final BlockPos blockPos;
    private WeakReference<World> worldReference;

    private DimPos(DimensionType dimension, BlockPos blockPos, World world) {
        this.dimension = dimension;
        this.blockPos = blockPos;
        this.worldReference = world != null && world.func_201670_d() ? new WeakReference<World>(world) : null;
    }

    private DimPos(DimensionType dimension, BlockPos blockPos) {
        this(dimension, blockPos, null);
    }

    @Nullable
    public World getWorld(boolean forceLoad) {
        if (this.worldReference == null) {
            return DimensionManager.getWorld((MinecraftServer)ServerLifecycleHooks.getCurrentServer(), (DimensionType)this.dimension, (boolean)false, (boolean)forceLoad);
        }
        World world = (World)this.worldReference.get();
        if (world == null) {
            world = DimensionManager.getWorld((MinecraftServer)ServerLifecycleHooks.getCurrentServer(), (DimensionType)this.dimension, (boolean)false, (boolean)forceLoad);
            this.worldReference = new WeakReference<World>(world);
        }
        return world;
    }

    public boolean isLoaded() {
        World world = this.getWorld(false);
        return world != null && world.func_175667_e(this.getBlockPos());
    }

    @Override
    public int compareTo(DimPos o) {
        int compareDim = Integer.compare(this.getDimension().func_186068_a(), o.getDimension().func_186068_a());
        if (compareDim == 0) {
            return MinecraftHelpers.compareBlockPos(this.getBlockPos(), o.getBlockPos());
        }
        return compareDim;
    }

    public boolean equals(Object o) {
        return o instanceof DimPos && this.compareTo((DimPos)o) == 0;
    }

    public int hashCode() {
        return 31 * this.getDimension().func_186068_a() + this.getBlockPos().hashCode();
    }

    public static DimPos of(World world, BlockPos blockPos) {
        return new DimPos(world.func_201675_m().func_186058_p(), blockPos, world);
    }

    public static DimPos of(DimensionType dimension, BlockPos blockPos) {
        return new DimPos(dimension, blockPos);
    }

    public DimensionType getDimension() {
        return this.dimension;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public WeakReference<World> getWorldReference() {
        return this.worldReference;
    }

    public void setWorldReference(WeakReference<World> worldReference) {
        this.worldReference = worldReference;
    }

    public String toString() {
        return "DimPos(dimension=" + this.getDimension() + ", blockPos=" + this.getBlockPos() + ", worldReference=" + this.getWorldReference() + ")";
    }
}

