/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.fluid;

import java.util.Objects;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.fluid.Tank;

public class SingleUseTank
extends Tank {
    public static final String NBT_ACCEPTED_FLUID = "acceptedFluid";
    private Fluid acceptedFluid;

    public SingleUseTank(int capacity) {
        super(capacity);
        this.setAcceptedFluid(Fluids.field_204541_a);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        Fluid acceptedFluid = this.getAcceptedFluid();
        int filled = 0;
        if (resource.isEmpty()) {
            filled = 0;
        } else {
            if (action.execute() && acceptedFluid == Fluids.field_204541_a) {
                acceptedFluid = resource.getFluid();
            }
            if (acceptedFluid == Fluids.field_204541_a || acceptedFluid == resource.getFluid()) {
                filled = super.fill(resource, action);
            }
        }
        if (filled > 0) {
            this.sendUpdate();
        }
        return filled;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(maxDrain, action);
        if (!drained.isEmpty()) {
            this.sendUpdate();
        }
        return drained;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(resource, action);
        if (!drained.isEmpty()) {
            this.sendUpdate();
        }
        return drained;
    }

    protected void sendUpdate() {
    }

    public void reset() {
        this.acceptedFluid = Fluids.field_204541_a;
        this.setValidator(fluidStack -> true);
    }

    public void setAcceptedFluid(Fluid fluid) {
        this.acceptedFluid = Objects.requireNonNull(fluid);
        if (fluid == Fluids.field_204541_a) {
            this.setValidator(fluidStack -> true);
        } else {
            this.setValidator(fluidStack -> fluidStack.getFluid() == fluid);
        }
    }

    public Fluid getAcceptedFluid() {
        return this.acceptedFluid;
    }

    @Override
    public void writeTankToNBT(CompoundNBT nbt) {
        super.writeTankToNBT(nbt);
        nbt.func_74778_a(NBT_ACCEPTED_FLUID, this.acceptedFluid.getRegistryName().toString());
    }

    @Override
    public void readTankFromNBT(CompoundNBT nbt) {
        super.readTankFromNBT(nbt);
        this.setAcceptedFluid((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.func_74779_i(NBT_ACCEPTED_FLUID))));
    }
}

