/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.fluid;

import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class Tank
extends FluidTank {
    public Tank(int capacity) {
        super(capacity);
    }

    public boolean isEmpty() {
        return this.getFluid().isEmpty() || this.getFluid().getAmount() <= 0;
    }

    public boolean isFull() {
        return !this.getFluid().isEmpty() && this.getFluid().getAmount() >= this.getCapacity();
    }

    public Fluid getFluidType() {
        return !this.getFluid().isEmpty() ? this.getFluid().getFluid() : null;
    }

    protected boolean replaceInnerFluid() {
        return true;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        if (this.replaceInnerFluid()) {
            super.writeToNBT(nbt);
        }
        this.writeTankToNBT(nbt);
        return nbt;
    }

    public FluidTank readFromNBT(CompoundNBT nbt) {
        if (this.replaceInnerFluid()) {
            if (nbt.func_74764_b("Empty")) {
                this.setFluid(null);
            }
            super.readFromNBT(nbt);
        }
        this.readTankFromNBT(nbt);
        return this;
    }

    public void writeTankToNBT(CompoundNBT nbt) {
        nbt.func_74768_a("capacity", this.getCapacity());
    }

    public void readTankFromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("capacity")) {
            this.setCapacity(nbt.func_74762_e("capacity"));
        }
    }
}

