/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.StringHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.cyclopscore.persist.nbt.INBTSerializable;

public final class L10NHelpers {
    public static final int MAX_TOOLTIP_LINE_LENGTH = 25;
    private static final String KEY_ENABLED = "general.cyclopscore.info.enabled";
    private static final String KEY_DISABLED = "general.cyclopscore.info.disabled";

    @OnlyIn(value=Dist.CLIENT)
    public static String localize(String key, Object ... params) {
        if (MinecraftHelpers.isModdedEnvironment()) {
            return I18n.func_135052_a((String)key, (Object[])params);
        }
        return String.format("%s: %s", key, Arrays.toString(params));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addStatusInfo(List<String> infoLines, boolean isEnabled, String statusPrefixKey) {
        String autoSupply = L10NHelpers.localize(KEY_DISABLED, new Object[0]);
        if (isEnabled) {
            autoSupply = L10NHelpers.localize(KEY_ENABLED, new Object[0]);
        }
        infoLines.add(L10NHelpers.localize(statusPrefixKey, autoSupply));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getLocalizedEntityName(String entityId) {
        return L10NHelpers.localize("entity." + entityId + ".name", new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addOptionalInfo(List<ITextComponent> list, String prefix) {
        String key = prefix + ".info";
        if (I18n.func_188566_a((String)key)) {
            if (MinecraftHelpers.isShifted()) {
                String localized = L10NHelpers.localize(key, new Object[0]);
                list.addAll(StringHelpers.splitLines(localized, 25, IInformationProvider.INFO_PREFIX).stream().map(StringTextComponent::new).collect(Collectors.toList()));
            } else {
                list.add(new TranslationTextComponent("general.cyclopscore.tooltip.info", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true))));
            }
        }
    }

    @Deprecated
    public static class UnlocalizedString
    implements INBTSerializable {
        private String parameterizedString;
        private Object[] parameters;

        public UnlocalizedString(String parameterizedString, Object ... parameters) {
            this.parameterizedString = parameterizedString;
            this.parameters = parameters;
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] instanceof UnlocalizedString || parameters[i] instanceof String) continue;
                parameters[i] = String.valueOf(parameters[i]);
            }
        }

        public UnlocalizedString() {
            this.parameterizedString = null;
            this.parameters = null;
        }

        public String localize() {
            Object[] realParameters = new Object[this.parameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                Object param = this.parameters[i];
                realParameters[i] = param instanceof UnlocalizedString ? ((UnlocalizedString)param).localize() : param;
            }
            return L10NHelpers.localize(this.parameterizedString, realParameters);
        }

        @Override
        public CompoundNBT toNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("parameterizedString", this.parameterizedString);
            ListNBT list = new ListNBT();
            for (Object parameter : this.parameters) {
                if (parameter instanceof UnlocalizedString) {
                    CompoundNBT objectTag = ((UnlocalizedString)parameter).toNBT();
                    objectTag.func_74778_a("type", "object");
                    list.add((Object)objectTag);
                    continue;
                }
                CompoundNBT stringTag = new CompoundNBT();
                stringTag.func_218657_a("value", (INBT)new StringNBT((String)parameter));
                stringTag.func_74778_a("type", "string");
                list.add((Object)stringTag);
            }
            tag.func_218657_a("parameters", (INBT)list);
            return tag;
        }

        @Override
        public void fromNBT(CompoundNBT tag) {
            this.parameterizedString = tag.func_74779_i("parameterizedString");
            ListNBT list = tag.func_150295_c("parameters", 10);
            this.parameters = new Object[list.size()];
            for (int i = 0; i < this.parameters.length; ++i) {
                CompoundNBT elementTag = list.func_150305_b(i);
                if ("object".equals(elementTag.func_74779_i("type"))) {
                    UnlocalizedString object = new UnlocalizedString();
                    object.fromNBT(elementTag);
                    this.parameters[i] = object;
                    continue;
                }
                this.parameters[i] = elementTag.func_74779_i("value");
            }
        }
    }
}

