/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;

public class WorldHelpers {
    public static final int CHUNK_SIZE = 16;
    private static final double TICK_LAG_REDUCTION_MODULUS_MODIFIER = 1.0;

    public static void setBiome(World world, BlockPos pos, Biome biome) {
        IChunk chunk = world.func_217349_x(pos);
        if (chunk != null) {
            BlockPos c = WorldHelpers.getChunkLocationFromWorldLocation(pos.func_177958_n(), 0, pos.func_177952_p());
            int rx = c.func_177958_n();
            int rz = c.func_177952_p();
            Biome[] biomeArray = chunk.func_201590_e();
            biomeArray[rz << 4 | rx] = biome;
            chunk.func_177427_f(true);
            world.func_72863_F().func_217206_a(chunk.func_76632_l(), false);
        } else {
            CyclopsCore.clog(Level.WARN, "Tried changing biome at non-existing chunk for position " + pos);
        }
    }

    public static boolean efficientTick(World world, int baseModulus, int ... params) {
        int mod = (int)((double)baseModulus * 1.0);
        if (mod == 0) {
            mod = 1;
        }
        int offset = 0;
        for (int param : params) {
            offset += param;
        }
        return world.field_73012_v.nextInt(mod) == Math.abs(offset) % mod;
    }

    public static boolean efficientTick(World world, int baseModulus, BlockPos blockPos) {
        return WorldHelpers.efficientTick(world, baseModulus, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public static BlockPos getChunkLocationFromWorldLocation(int x, int y, int z) {
        return new BlockPos(x & 0xF, y, z & 0xF);
    }

    public static <T> T foldArea(World world, int[] areaMin, int[] areaMax, BlockPos blockPos, WorldFoldingFunction<T, T> folder, T value) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        for (int xc = x - areaMin[0]; xc <= x + areaMax[0]; ++xc) {
            for (int yc = y - areaMin[1]; yc <= y + areaMax[1]; ++yc) {
                for (int zc = z - areaMin[2]; zc <= z + areaMax[2]; ++zc) {
                    value = folder.apply(value, world, new BlockPos(xc, yc, zc));
                }
            }
        }
        return value;
    }

    public static <T> T foldArea(World world, int area, BlockPos blockPos, WorldFoldingFunction<T, T> folder, T value) {
        return WorldHelpers.foldArea(world, new int[]{area, area, area}, new int[]{area, area, area}, blockPos, folder, value);
    }

    public static interface WorldFoldingFunction<F, T> {
        @Nullable
        public T apply(@Nullable F var1, World var2, BlockPos var3);
    }
}

