/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import net.minecraft.advancements.Advancement;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.AdvancementHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;

@OnlyIn(value=Dist.CLIENT)
public class AdvancementButton
extends AdvancedButton {
    private final ResourceLocation advancementId;

    public AdvancementButton(ResourceLocation advancementId) {
        this.advancementId = advancementId;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void renderTooltip(int mx, int my) {
        super.renderTooltip(mx, my);
        GlStateManager.pushMatrix();
        if (mx >= this.x && my >= this.y && mx <= this.x + 16 && my <= this.y + 16) {
            ArrayList lines = Lists.newArrayList();
            Advancement advancement = AdvancementHelpers.getAdvancement(Dist.CLIENT, this.advancementId);
            if (advancement != null) {
                lines.add(advancement.func_192068_c().func_192297_a().func_150254_d());
                lines.add(TextFormatting.GRAY.toString() + advancement.func_192068_c().func_193222_b().func_150254_d());
            }
            this.gui.renderTooltip(lines, mx, my);
        }
        GlStateManager.popMatrix();
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
    }
}

