/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.infobook.pageelement.IReward;
import org.cyclops.cyclopscore.network.packet.AdvancementRewardsObtainPacket;

public class AdvancementRewards {
    private static final Map<String, AdvancementRewards> ACHIEVEMENT_REWARDS = Maps.newHashMap();
    public static String NBT_KEY_OBTAINED_PREFIX = "cyclopscore:obtainedAdvancements:";
    private final String id;
    private final List<ResourceLocation> advancements;
    private final List<IReward> rewards;

    public AdvancementRewards(String id, List<ResourceLocation> advancements, List<IReward> rewards) {
        this.id = id;
        this.advancements = advancements;
        this.rewards = rewards;
        if (ACHIEVEMENT_REWARDS.put(id, this) != null) {
            throw new IllegalArgumentException(String.format("Duplicate advancements rewards id '%s' was found.", id));
        }
    }

    public static AdvancementRewards getAdvancementRewards(String achievementRewardsId) {
        return ACHIEVEMENT_REWARDS.get(achievementRewardsId);
    }

    protected String getNbtTagKey() {
        return NBT_KEY_OBTAINED_PREFIX + this.id;
    }

    public boolean isObtained(PlayerEntity player) {
        return EntityHelpers.getPersistedPlayerNbt(player).func_74767_n(this.getNbtTagKey());
    }

    public void obtain(PlayerEntity player) {
        if (!this.isObtained(player)) {
            if (player.field_70170_p.func_201670_d()) {
                CyclopsCore._instance.getPacketHandler().sendToServer(new AdvancementRewardsObtainPacket(this.id));
            } else {
                for (IReward reward : this.getRewards()) {
                    reward.obtain(player);
                }
            }
            CompoundNBT tag = player.getPersistentData();
            if (!tag.func_74764_b("PlayerPersisted")) {
                tag.func_218657_a("PlayerPersisted", (INBT)new CompoundNBT());
            }
            CompoundNBT persistedTag = tag.func_74775_l("PlayerPersisted");
            persistedTag.func_74757_a(this.getNbtTagKey(), true);
        }
    }

    public String getId() {
        return this.id;
    }

    public List<ResourceLocation> getAdvancements() {
        return this.advancements;
    }

    public List<IReward> getRewards() {
        return this.rewards;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdvancementRewards)) {
            return false;
        }
        AdvancementRewards other = (AdvancementRewards)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<ResourceLocation> this$advancements = this.getAdvancements();
        List<ResourceLocation> other$advancements = other.getAdvancements();
        if (this$advancements == null ? other$advancements != null : !((Object)this$advancements).equals(other$advancements)) {
            return false;
        }
        List<IReward> this$rewards = this.getRewards();
        List<IReward> other$rewards = other.getRewards();
        return !(this$rewards == null ? other$rewards != null : !((Object)this$rewards).equals(other$rewards));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdvancementRewards;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 0 : $id.hashCode());
        List<ResourceLocation> $advancements = this.getAdvancements();
        result = result * 59 + ($advancements == null ? 0 : ((Object)$advancements).hashCode());
        List<IReward> $rewards = this.getRewards();
        result = result * 59 + ($rewards == null ? 0 : ((Object)$rewards).hashCode());
        return result;
    }

    public String toString() {
        return "AdvancementRewards(id=" + this.getId() + ", advancements=" + this.getAdvancements() + ", rewards=" + this.getRewards() + ")";
    }
}

