/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.lwjgl.opengl.GL11;

public abstract class RecipeAppendix<T>
extends SectionAppendix {
    protected static final int SLOT_SIZE = 16;
    protected static final int TICK_DELAY = 30;
    protected T recipe;
    protected Map<AdvancedButtonEnum, AdvancedButton> renderItemHolders = Maps.newHashMap();

    public RecipeAppendix(IInfoBook infoBook, T recipe) {
        super(infoBook);
        this.recipe = recipe;
    }

    protected int getTick(ScreenInfoBook gui) {
        return gui.getTick() / 30;
    }

    protected ItemStack prepareItemStacks(List<ItemStack> itemStacks, int tick) {
        if (itemStacks.size() == 0) {
            return ItemStack.field_190927_a;
        }
        return this.prepareItemStack(itemStacks.get(tick % itemStacks.size()).func_77946_l(), tick);
    }

    protected ItemStack prepareItemStack(ItemStack itemStack, int tick) {
        return itemStack;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderItem(ScreenInfoBook gui, int x, int y, ItemStack itemStack, int mx, int my, AdvancedButtonEnum buttonEnum) {
        this.renderItem(gui, x, y, itemStack, mx, my, buttonEnum, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderItem(ScreenInfoBook gui, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, AdvancedButtonEnum buttonEnum) {
        this.renderItem(gui, x, y, itemStack, mx, my, renderOverlays, buttonEnum, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderItem(ScreenInfoBook gui, int x, int y, ItemStack itemStack, int mx, int my, AdvancedButtonEnum buttonEnum, float chance) {
        this.renderItem(gui, x, y, itemStack, mx, my, true, buttonEnum, chance);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderItem(ScreenInfoBook gui, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, AdvancedButtonEnum buttonEnum, float chance) {
        RecipeAppendix.renderItemForButton(gui, x, y, itemStack, mx, my, renderOverlays, buttonEnum != null ? (ItemButton)this.renderItemHolders.get(buttonEnum) : null, chance);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemForButton(ScreenInfoBook gui, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, ItemButton button) {
        RecipeAppendix.renderItemForButton(gui, x, y, itemStack, mx, my, renderOverlays, button, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemForButton(ScreenInfoBook gui, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, ItemButton button, float chance) {
        if (renderOverlays) {
            gui.drawOuterBorder(x, y, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
        }
        if (itemStack != null) {
            ItemRenderer renderItem = Minecraft.func_71410_x().func_175599_af();
            GlStateManager.pushMatrix();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)771);
            RenderHelper.func_74520_c();
            GlStateManager.enableRescaleNormal();
            GL11.glEnable((int)2929);
            renderItem.func_180450_b(itemStack, x, y);
            if (renderOverlays) {
                renderItem.func_175030_a(Minecraft.func_71410_x().field_71466_p, itemStack, x, y);
            }
            RenderHelper.func_74518_a();
            GlStateManager.popMatrix();
            GL11.glDisable((int)2929);
            if (chance != 1.0f) {
                String chanceString = chance * 100.0f + "%";
                gui.drawScaledCenteredString(chanceString, x - 3, y + 4, gui.getFontRenderer().func_78256_a(chanceString), 1.0f, 18, 0);
                gui.drawScaledCenteredString(chanceString, x - 4, y + 3, gui.getFontRenderer().func_78256_a(chanceString), 1.0f, 18, Helpers.RGBToInt(255, 255, 255));
            }
            if (button != null && renderOverlays) {
                button.update(x, y, itemStack, gui);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderFluid(ScreenInfoBook gui, int x, int y, FluidStack fluidStack, int mx, int my, AdvancedButtonEnum buttonEnum) {
        this.renderFluid(gui, x, y, fluidStack, mx, my, true, buttonEnum);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderFluid(ScreenInfoBook gui, int x, int y, FluidStack fluidStack, int mx, int my, boolean renderOverlays, AdvancedButtonEnum buttonEnum) {
        RecipeAppendix.renderFluidForButton(gui, x, y, fluidStack, mx, my, renderOverlays, buttonEnum != null ? (FluidButton)this.renderItemHolders.get(buttonEnum) : null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderFluidForButton(ScreenInfoBook gui, int x, int y, FluidStack fluidStack, int mx, int my, boolean renderOverlays, FluidButton button) {
        if (renderOverlays) {
            gui.drawOuterBorder(x, y, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
        }
        if (fluidStack != null) {
            GuiHelpers.renderFluidSlot((AbstractGui)gui, fluidStack, x, y);
            if (button != null && renderOverlays) {
                button.update(x, y, fluidStack, gui);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemTooltip(ScreenInfoBook gui, int x, int y, ItemStack itemStack, int mx, int my) {
        GlStateManager.pushMatrix();
        if (mx >= x && my >= y && mx <= x + 16 && my <= y + 16 && itemStack != null) {
            gui.renderTooltip(itemStack, mx, my);
        }
        GlStateManager.popMatrix();
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.blendFunc((int)770, (int)771);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderFluidTooltip(ScreenInfoBook gui, int x, int y, FluidStack fluidStack, int mx, int my) {
        GlStateManager.pushMatrix();
        if (mx >= x && my >= y && mx <= x + 16 && my <= y + 16 && fluidStack != null) {
            ArrayList lines = Lists.newArrayList();
            lines.add(fluidStack.getFluid().getAttributes().getRarity((FluidStack)fluidStack).field_77937_e + L10NHelpers.localize(fluidStack.getTranslationKey(), new Object[0]));
            lines.add(TextFormatting.GRAY.toString() + fluidStack.getAmount() + " mB");
            gui.renderTooltip(lines, mx, my);
        }
        GlStateManager.popMatrix();
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
    }

    @Override
    protected int getHeight() {
        return this.getHeightInner() + this.getAdditionalHeight();
    }

    protected abstract int getHeightInner();

    protected int getAdditionalHeight() {
        return 5;
    }

    @Override
    protected int getOffsetY() {
        return this.getAdditionalHeight();
    }

    protected abstract String getUnlocalizedTitle();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public final void drawElement(ScreenInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        int yOffset = this.getAdditionalHeight();
        gui.drawOuterBorder(x - 1, y - 1 - yOffset, this.getWidth() + 2, this.getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(x + width / 2, y - 2 - yOffset);
        gui.drawScaledCenteredString(L10NHelpers.localize(this.getUnlocalizedTitle(), new Object[0]), x, y - 2 - yOffset, width, 0.9f, gui.getBannerWidth() - 6, gui.getTitleColor());
        this.drawElementInner(gui, x, y, width, height, page, mx, my);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void postDrawElement(ScreenInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        this.renderToolTips(gui, mx, my);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void drawElementInner(ScreenInfoBook var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    @OnlyIn(value=Dist.CLIENT)
    protected void renderToolTips(ScreenInfoBook gui, int mx, int my) {
        for (AdvancedButton renderItemHolder : this.renderItemHolders.values()) {
            renderItemHolder.renderTooltip(mx, my);
        }
    }

    @Override
    public void preBakeElement(InfoSection infoSection) {
        this.renderItemHolders.clear();
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        infoSection.addAdvancedButtons(this.getPage(), this.renderItemHolders.values());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FluidButton
    extends ElementButton<FluidStack> {
        public FluidButton(IInfoBook infoBook) {
            super(infoBook);
        }

        @Override
        protected String getTranslationKey(FluidStack element) {
            return element.getTranslationKey();
        }

        @Override
        public void renderTooltip(int mx, int my) {
            RecipeAppendix.renderFluidTooltip(this.gui, this.x, this.y, (FluidStack)this.getElement(), mx, my);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemButton
    extends ElementButton<ItemStack> {
        public ItemButton(IInfoBook infoBook) {
            super(infoBook);
        }

        @Override
        public void update(int x, int y, ItemStack element, ScreenInfoBook gui) {
            super.update(x, y, element.func_190926_b() ? null : element, gui);
        }

        @Override
        public void renderTooltip(int mx, int my) {
            RecipeAppendix.renderItemTooltip(this.gui, this.x, this.y, (ItemStack)this.getElement(), mx, my);
        }

        @Override
        protected String getTranslationKey(ItemStack element) {
            return element.func_77977_a();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class ElementButton<E>
    extends AdvancedButton {
        private final IInfoBook infoBook;
        private E element;

        public ElementButton(IInfoBook infoBook) {
            this.infoBook = infoBook;
        }

        public E getElement() {
            return this.element;
        }

        public void update(int x, int y, E element, ScreenInfoBook gui) {
            this.element = element;
            InfoSection target = null;
            if (this.element != null) {
                String translationKey = this.getTranslationKey(element);
                Pair<InfoSection, Integer> pair = this.infoBook.getConfigLinks().get(translationKey);
                if (pair != null) {
                    target = (InfoSection)pair.getLeft();
                }
            }
            super.update(x, y, "empty", target, gui);
        }

        protected abstract String getTranslationKey(E var1);

        @Override
        public void renderButton(int mouseX, int mouseY, float partialTicks) {
            if (this.isVisible() && this.isHover(mouseX, mouseY)) {
                this.gui.drawOuterBorder(this.x, this.y, 16, 16, 0.392f, 0.392f, 0.6f, 0.9f);
            }
        }

        @Override
        public boolean isVisible() {
            return super.isVisible() && this.element != null;
        }
    }
}

