/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;
import java.util.PrimitiveIterator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import org.cyclops.cyclopscore.inventory.IndexedSlotlessItemHandlerWrapper;
import org.cyclops.cyclopscore.inventory.LargeInventory;

public class IndexedInventory
extends LargeInventory
implements IndexedSlotlessItemHandlerWrapper.IInventoryIndexReference {
    private final Map<Item, Int2ObjectMap<ItemStack>> index = Maps.newIdentityHashMap();
    private IntSet emptySlots = new IntAVLTreeSet();
    private IntSet nonEmptySlots = new IntAVLTreeSet();

    public IndexedInventory() {
        this(0, 0);
    }

    public IndexedInventory(int size, int stackLimit) {
        super(size, stackLimit);
        this.createIndex();
    }

    protected void createIndex() {
        this.index.clear();
        this.nonEmptySlots.clear();
        this.emptySlots.clear();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (!itemStack.func_190926_b()) {
                Int2ObjectOpenHashMap stacks = this.index.get(itemStack.func_77973_b());
                if (stacks == null) {
                    stacks = new Int2ObjectOpenHashMap();
                    this.index.put(itemStack.func_77973_b(), (Int2ObjectMap<ItemStack>)stacks);
                }
                stacks.put(i, (Object)itemStack);
                this.nonEmptySlots.add(i);
                continue;
            }
            this.emptySlots.add(i);
        }
    }

    @Override
    public void readFromNBT(CompoundNBT data, String tag) {
        super.readFromNBT(data, tag);
        this.createIndex();
    }

    @Override
    public void func_70299_a(int slotId, ItemStack itemStack) {
        Int2ObjectMap<ItemStack> stacks;
        ItemStack oldStack = this.func_70301_a(slotId);
        boolean wasEmpty = oldStack.func_190926_b();
        boolean isEmpty = itemStack.func_190926_b();
        if (!oldStack.func_190926_b()) {
            stacks = this.index.get(oldStack.func_77973_b());
            if (stacks != null) {
                stacks.remove(slotId);
            }
            if (stacks.isEmpty()) {
                this.index.remove(oldStack.func_77973_b());
            }
        }
        if (!itemStack.func_190926_b()) {
            stacks = this.index.get(itemStack.func_77973_b());
            if (stacks == null) {
                stacks = new Int2ObjectOpenHashMap();
                this.index.put(itemStack.func_77973_b(), stacks);
            }
            stacks.put(slotId, (Object)itemStack);
        }
        super.func_70299_a(slotId, itemStack);
        if (wasEmpty && !isEmpty) {
            this.emptySlots.remove(slotId);
            this.nonEmptySlots.add(slotId);
        }
        if (!wasEmpty && isEmpty) {
            this.emptySlots.add(slotId);
            this.nonEmptySlots.remove(slotId);
        }
        if (this.nonEmptySlots.size() + this.emptySlots.size() != this.func_70302_i_()) {
            throw new IllegalStateException(String.format("Indexed inventory at inconsistent state %s %s %s (slot: %s).", this.nonEmptySlots, this.emptySlots, this.func_70302_i_(), slotId));
        }
    }

    @Override
    public void func_174888_l() {
        super.func_174888_l();
        this.index.clear();
    }

    @Override
    public Map<Item, Int2ObjectMap<ItemStack>> getIndex() {
        return this.index;
    }

    @Override
    public PrimitiveIterator.OfInt getEmptySlots() {
        return new IndexedSlotlessItemHandlerWrapper.WrappedIntIterator(this.emptySlots.iterator());
    }

    @Override
    public PrimitiveIterator.OfInt getNonEmptySlots() {
        return new IndexedSlotlessItemHandlerWrapper.WrappedIntIterator(this.nonEmptySlots.iterator());
    }
}

