/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.inventory.IValueNotifiable;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.SyncedGuiVariable;
import org.cyclops.cyclopscore.inventory.container.button.IContainerButtonAction;
import org.cyclops.cyclopscore.inventory.container.button.IContainerButtonClickAcceptorServer;
import org.cyclops.cyclopscore.inventory.slot.SlotArmor;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.cyclopscore.network.packet.ValueNotifyPacket;

public abstract class ContainerExtended
extends Container
implements IContainerButtonClickAcceptorServer<ContainerExtended>,
IValueNotifier,
IValueNotifiable {
    private static final EquipmentSlotType[] EQUIPMENT_SLOTS = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    protected static final int ITEMBOX = 18;
    private final Map<String, IContainerButtonAction<ContainerExtended>> buttonActions = Maps.newHashMap();
    private final Map<Integer, CompoundNBT> values = Maps.newHashMap();
    private final List<SyncedGuiVariable<?>> syncedGuiVariables = Lists.newArrayList();
    private int nextValueId = 0;
    private IValueNotifiable guiValueListener = null;
    private IInventory playerIInventory;
    protected final PlayerEntity player;
    protected int offsetX = 0;
    protected int offsetY = 0;
    private int dragMode = -1;
    private int dragEvent;
    private final Set<Slot> dragSlots = Sets.newHashSet();

    public ContainerExtended(@Nullable ContainerType<?> type, int id, PlayerInventory inventory) {
        super(type, id);
        this.playerIInventory = inventory;
        this.player = inventory.field_70458_d;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.player.field_70170_p.func_201670_d()) {
            for (SyncedGuiVariable<?> syncedGuiVariable : this.syncedGuiVariables) {
                syncedGuiVariable.detectAndSendChanges();
            }
        }
    }

    public void setGuiValueListener(IValueNotifiable listener) {
        this.guiValueListener = listener;
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        if (!this.player.func_130014_f_().func_201670_d()) {
            this.initializeValues();
        }
    }

    protected void initializeValues() {
    }

    protected Slot createNewSlot(IInventory inventory, int index, int x, int y) {
        return new Slot(inventory, index, x, y);
    }

    protected Slot func_75146_a(Slot slot) {
        slot.field_75223_e += this.offsetX;
        slot.field_75221_f += this.offsetY;
        return super.func_75146_a(slot);
    }

    protected void addInventory(IInventory inventory, int indexOffset, int offsetX, int offsetY, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                this.func_75146_a(this.createNewSlot(inventory, x + y * cols + indexOffset, offsetX + x * 18, offsetY + y * 18));
            }
        }
    }

    protected void addPlayerInventory(PlayerInventory inventory, int offsetX, int offsetY) {
        int rows = 3;
        int cols = 9;
        this.addInventory((IInventory)inventory, 0, offsetX, offsetY + 58, 1, cols);
        this.addInventory((IInventory)inventory, cols, offsetX, offsetY, rows, cols);
    }

    protected void addPlayerArmorInventory(PlayerInventory inventory, int offsetX, int offsetY) {
        for (int k = 0; k < 4; ++k) {
            EquipmentSlotType equipmentSlot = EQUIPMENT_SLOTS[k];
            this.func_75146_a(new SlotArmor((IInventory)inventory, 36 + (3 - k), offsetX, offsetY + k * 18, inventory.field_70458_d, equipmentSlot));
        }
    }

    protected abstract int getSizeInventory();

    protected int getSlotStart(int originSlot, int slotStart, boolean reverse) {
        return slotStart;
    }

    protected int getSlotRange(int originSlot, int slotRange, boolean reverse) {
        return slotRange;
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotID) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotID);
        int slots = this.getSizeInventory();
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c().func_77946_l();
            stack = stackInSlot.func_77946_l();
            if (slotID < slots ? !this.func_75135_a(stackInSlot, this.getSlotStart(slotID, slots, true), this.getSlotRange(slotID, this.field_75151_b.size(), true), true) : !this.func_75135_a(stackInSlot, this.getSlotStart(slotID, 0, false), this.getSlotRange(slotID, slots, false), false)) {
                return ItemStack.field_190927_a;
            }
            if (stackInSlot.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75215_d(stackInSlot);
            }
            if (stackInSlot.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stackInSlot);
        }
        return stack;
    }

    protected boolean func_75135_a(ItemStack stack, int slotStart, int slotRange, boolean reverse) {
        ItemStack existingStack;
        Slot slot;
        boolean successful = false;
        int slotIndex = slotStart;
        int maxStack = stack.func_77976_d();
        if (reverse) {
            slotIndex = slotRange - 1;
        }
        if (stack.func_77985_e()) {
            while (stack.func_190916_E() > 0 && (!reverse && slotIndex < slotRange || reverse && slotIndex >= slotStart)) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                int maxSlotSize = Math.min(slot.func_75219_a(), maxStack);
                existingStack = slot.func_75211_c().func_77946_l();
                if (slot.func_75214_a(stack) && !existingStack.func_190926_b() && existingStack.func_77973_b() == stack.func_77973_b() && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack)) {
                    int existingSize = existingStack.func_190916_E() + stack.func_190916_E();
                    if (existingSize <= maxSlotSize) {
                        stack.func_190920_e(0);
                        existingStack.func_190920_e(existingSize);
                        slot.func_75215_d(existingStack);
                        successful = true;
                    } else if (existingStack.func_190916_E() < maxSlotSize) {
                        stack.func_190918_g(maxSlotSize - existingStack.func_190916_E());
                        existingStack.func_190920_e(maxSlotSize);
                        slot.func_75215_d(existingStack);
                        successful = true;
                    }
                }
                if (reverse) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        if (stack.func_190916_E() > 0) {
            slotIndex = reverse ? slotRange - 1 : slotStart;
            while (stack.func_190916_E() > 0 && (!reverse && slotIndex < slotRange || reverse && slotIndex >= slotStart)) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                existingStack = slot.func_75211_c().func_77946_l();
                if (slot.func_75214_a(stack) && existingStack.func_190926_b()) {
                    int placedAmount = Math.min(stack.func_190916_E(), slot.func_75219_a());
                    ItemStack toPut = stack.func_77946_l();
                    toPut.func_190920_e(placedAmount);
                    slot.func_75215_d(toPut);
                    stack.func_190918_g(placedAmount);
                    successful = true;
                }
                if (reverse) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        return successful;
    }

    public IInventory getPlayerIInventory() {
        return this.playerIInventory;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, PlayerEntity player) {
        Slot slot = slotId < 0 ? null : (Slot)this.field_75151_b.get(slotId);
        PlayerInventory inventoryplayer = player.field_71071_by;
        if (clickType == ClickType.QUICK_CRAFT) {
            int j1 = this.dragEvent;
            this.dragEvent = ContainerExtended.func_94532_c((int)dragType);
            if ((j1 != 1 || this.dragEvent != 2) && j1 != this.dragEvent) {
                this.func_94533_d();
            } else if (inventoryplayer.func_70445_o().func_190926_b()) {
                this.func_94533_d();
            } else if (this.dragEvent == 0) {
                this.dragMode = ContainerExtended.func_94529_b((int)dragType);
                if (ContainerExtended.func_180610_a((int)this.dragMode, (PlayerEntity)player)) {
                    this.dragEvent = 1;
                    this.dragSlots.clear();
                } else {
                    this.func_94533_d();
                }
            } else if (this.dragEvent == 1) {
                Slot slot7 = (Slot)this.field_75151_b.get(slotId);
                ItemStack itemstack12 = inventoryplayer.func_70445_o();
                if (slot7 != null && ContainerExtended.func_94527_a((Slot)slot7, (ItemStack)itemstack12, (boolean)true) && slot7.func_75214_a(itemstack12) && (this.dragMode == 2 || itemstack12.func_190916_E() > this.dragSlots.size()) && this.func_94531_b(slot7)) {
                    this.dragSlots.add(slot7);
                }
            } else if (this.dragEvent == 2) {
                if (!this.dragSlots.isEmpty()) {
                    ItemStack itemstack9 = inventoryplayer.func_70445_o().func_77946_l();
                    int k1 = inventoryplayer.func_70445_o().func_190916_E();
                    int phantomCount = 0;
                    for (Slot slot8 : this.dragSlots) {
                        ItemStack itemstack13 = inventoryplayer.func_70445_o();
                        if (slot8 == null || !ContainerExtended.func_94527_a((Slot)slot8, (ItemStack)itemstack13, (boolean)true) || !slot8.func_75214_a(itemstack13) || this.dragMode != 2 && itemstack13.func_190916_E() < this.dragSlots.size() || !this.func_94531_b(slot8)) continue;
                        ItemStack itemstack14 = itemstack9.func_77946_l();
                        int j3 = slot8.func_75216_d() ? slot8.func_75211_c().func_190916_E() : 0;
                        ContainerExtended.func_94525_a(this.dragSlots, (int)this.dragMode, (ItemStack)itemstack14, (int)j3);
                        int k3 = Math.min(itemstack14.func_77976_d(), slot8.func_178170_b(itemstack14));
                        if (itemstack14.func_190916_E() > k3) {
                            itemstack14.func_190920_e(k3);
                        }
                        k1 -= itemstack14.func_190916_E() - j3;
                        slot8.func_75215_d(itemstack14);
                        if (!(slot8 instanceof SlotExtended) || !((SlotExtended)slot8).isPhantom()) continue;
                        phantomCount += itemstack14.func_190916_E() - j3;
                    }
                    itemstack9.func_190920_e(k1 + phantomCount);
                    inventoryplayer.func_70437_b(itemstack9);
                }
                this.func_94533_d();
            } else {
                this.func_94533_d();
            }
            return ItemStack.field_190927_a;
        }
        if (this.dragEvent != 0) {
            this.func_94533_d();
            return ItemStack.field_190927_a;
        }
        if (slot instanceof SlotExtended && ((SlotExtended)slot).isPhantom()) {
            return this.slotClickPhantom(slot, dragType, clickType, player);
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    protected void func_94533_d() {
        super.func_94533_d();
        this.dragEvent = 0;
        this.dragSlots.clear();
    }

    private ItemStack slotClickPhantom(Slot slot, int mouseButton, ClickType clickType, PlayerEntity player) {
        ItemStack stack = ItemStack.field_190927_a;
        if (mouseButton == 2) {
            if (((SlotExtended)slot).isAdjustable()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
        } else if (mouseButton == 0 || mouseButton == 1) {
            PlayerInventory playerInv = player.field_71071_by;
            slot.func_75218_e();
            ItemStack stackSlot = slot.func_75211_c();
            ItemStack stackHeld = playerInv.func_70445_o();
            if (!stackSlot.func_190926_b()) {
                stack = stackSlot.func_77946_l();
            }
            if (stackSlot.func_190926_b()) {
                if (!stackHeld.func_190926_b() && slot.func_75214_a(stackHeld)) {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, clickType);
                }
            } else if (stackHeld.func_190926_b()) {
                this.adjustPhantomSlot(slot, mouseButton, clickType);
                slot.func_190901_a(player, playerInv.func_70445_o());
            } else if (slot.func_75214_a(stackHeld)) {
                if (ItemMatch.areItemStacksEqual((ItemStack)stackSlot, (ItemStack)stackHeld, (int)5)) {
                    this.adjustPhantomSlot(slot, mouseButton, clickType);
                } else {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, clickType);
                }
            }
        }
        return stack;
    }

    protected void adjustPhantomSlot(Slot slot, int mouseButton, ClickType clickType) {
        int stackSize;
        if (!((SlotExtended)slot).isAdjustable()) {
            return;
        }
        ItemStack stackSlot = slot.func_75211_c();
        if (clickType == ClickType.QUICK_MOVE) {
            stackSize = mouseButton == 0 ? (stackSlot.func_190916_E() + 1) / 2 : stackSlot.func_190916_E() * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.func_190916_E() - 1 : stackSlot.func_190916_E() + 1;
        }
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        stackSlot.func_190920_e(stackSize);
        if (stackSlot.func_190916_E() <= 0) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
    }

    protected void fillPhantomSlot(Slot slot, ItemStack stackHeld, int mouseButton, ClickType clickType) {
        int stackSize;
        if (!((SlotExtended)slot).isAdjustable()) {
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.func_190916_E() : 1;
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        ItemStack phantomStack = stackHeld.func_77946_l();
        phantomStack.func_190920_e(stackSize);
        slot.func_75215_d(phantomStack);
    }

    @Override
    public void putButtonAction(String buttonId, IContainerButtonAction<ContainerExtended> action) {
        this.buttonActions.put(buttonId, action);
    }

    @Override
    public boolean onButtonClick(String buttonId) {
        IContainerButtonAction<ContainerExtended> action = this.buttonActions.get(buttonId);
        if (action != null) {
            action.onAction(buttonId, this);
            return true;
        }
        return false;
    }

    protected int getNextValueId() {
        return this.nextValueId++;
    }

    @Override
    public void setValue(int valueId, CompoundNBT value) {
        if (!this.values.containsKey(valueId) || !this.values.get(valueId).equals((Object)value)) {
            if (!this.player.func_130014_f_().func_201670_d()) {
                CyclopsCore._instance.getPacketHandler().sendToPlayer(new ValueNotifyPacket(this.func_216957_a(), valueId, value), (ServerPlayerEntity)this.player);
            } else {
                CyclopsCore._instance.getPacketHandler().sendToServer(new ValueNotifyPacket(this.func_216957_a(), valueId, value));
            }
            this.values.put(valueId, value);
        }
    }

    @Override
    public CompoundNBT getValue(int valueId) {
        return this.values.get(valueId);
    }

    @Override
    public Set<Integer> getValueIds() {
        return this.values.keySet();
    }

    @Override
    public void onUpdate(int valueId, CompoundNBT value) {
        this.values.put(valueId, value);
        if (this.guiValueListener != null) {
            this.guiValueListener.onUpdate(valueId, value);
        }
    }

    public <T> Supplier<T> registerSyncedVariable(Class<T> clazz, Supplier<T> serverValueSupplier) {
        SyncedGuiVariable<T> variable = new SyncedGuiVariable<T>(this, clazz, serverValueSupplier);
        this.syncedGuiVariables.add(variable);
        return variable;
    }
}

