/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.nbt.path.parse;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import org.cyclops.cyclopscore.nbt.path.INbtPathExpression;
import org.cyclops.cyclopscore.nbt.path.NbtPathExpressionMatches;
import org.cyclops.cyclopscore.nbt.path.parse.INbtPathExpressionParseHandler;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionExecutionContext;

public abstract class NbtPathExpressionParseHandlerBooleanRelationalAdapter
implements INbtPathExpressionParseHandler {
    private final Pattern regex;

    protected NbtPathExpressionParseHandlerBooleanRelationalAdapter(String relation) {
        this.regex = Pattern.compile("^ *" + relation + " *([0-9]+(.[0-9]+)?)");
    }

    protected abstract boolean getRelationalValue(double var1, double var3);

    @Override
    @Nullable
    public INbtPathExpressionParseHandler.HandleResult handlePrefixOf(String nbtPathExpression, int pos) {
        Matcher matcher = this.regex.matcher(nbtPathExpression).region(pos, nbtPathExpression.length());
        if (!matcher.find()) {
            return INbtPathExpressionParseHandler.HandleResult.INVALID;
        }
        String targetDoubleString = matcher.group(1);
        double targetDouble = Double.parseDouble(targetDoubleString);
        return new INbtPathExpressionParseHandler.HandleResult(new Expression(targetDouble, this), matcher.group().length());
    }

    public static class Expression
    implements INbtPathExpression {
        private final double targetDouble;
        private final NbtPathExpressionParseHandlerBooleanRelationalAdapter handler;

        public Expression(double targetDouble, NbtPathExpressionParseHandlerBooleanRelationalAdapter handler) {
            this.targetDouble = targetDouble;
            this.handler = handler;
        }

        double getTargetDouble() {
            return this.targetDouble;
        }

        @Override
        public NbtPathExpressionMatches matchContexts(Stream<NbtPathExpressionExecutionContext> executionContexts) {
            return new NbtPathExpressionMatches(executionContexts.map(executionContext -> {
                INBT nbt = executionContext.getCurrentTag();
                if (nbt instanceof NumberNBT) {
                    NumberNBT tag = (NumberNBT)nbt;
                    return new NbtPathExpressionExecutionContext((INBT)new ByteNBT(this.handler.getRelationalValue(tag.func_150286_g(), this.getTargetDouble()) ? (byte)1 : (byte)0), (NbtPathExpressionExecutionContext)executionContext);
                }
                return new NbtPathExpressionExecutionContext((INBT)new ByteNBT(0), (NbtPathExpressionExecutionContext)executionContext);
            }));
        }
    }
}

