/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.nbt.path.parse;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import org.cyclops.cyclopscore.nbt.path.INbtPathExpression;
import org.cyclops.cyclopscore.nbt.path.NbtPathExpressionMatches;
import org.cyclops.cyclopscore.nbt.path.parse.INbtPathExpressionParseHandler;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionExecutionContext;

public class NbtPathExpressionParseHandlerStringEqual
implements INbtPathExpressionParseHandler {
    private static final Pattern REGEX_EQUAL = Pattern.compile("^ *== *\"([^\"]*)\"");

    @Override
    @Nullable
    public INbtPathExpressionParseHandler.HandleResult handlePrefixOf(String nbtPathExpression, int pos) {
        Matcher matcher = REGEX_EQUAL.matcher(nbtPathExpression).region(pos, nbtPathExpression.length());
        if (!matcher.find()) {
            return INbtPathExpressionParseHandler.HandleResult.INVALID;
        }
        String targetString = matcher.group(1);
        return new INbtPathExpressionParseHandler.HandleResult(new Expression(targetString), matcher.group().length());
    }

    public static class Expression
    implements INbtPathExpression {
        private final String targetString;

        public Expression(String targetString) {
            this.targetString = targetString;
        }

        String getTargetString() {
            return this.targetString;
        }

        @Override
        public NbtPathExpressionMatches matchContexts(Stream<NbtPathExpressionExecutionContext> executionContexts) {
            return new NbtPathExpressionMatches(executionContexts.map(executionContext -> {
                INBT nbt = executionContext.getCurrentTag();
                if (nbt.func_74732_a() == 8) {
                    StringNBT tag = (StringNBT)nbt;
                    return new NbtPathExpressionExecutionContext((INBT)new ByteNBT(this.getTargetString().equals(tag.func_150285_a_()) ? (byte)1 : (byte)0), (NbtPathExpressionExecutionContext)executionContext);
                }
                return new NbtPathExpressionExecutionContext((INBT)new ByteNBT(0), (NbtPathExpressionExecutionContext)executionContext);
            }));
        }
    }
}

