/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.nbt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.INBTSerializable;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;

public abstract class NBTClassType<T> {
    public static Map<Class<?>, NBTClassType<?>> NBTYPES = new IdentityHashMap();

    public static <T> NBTClassType<T> getClassType(Class<T> clazz) {
        return NBTYPES.get(clazz);
    }

    public static <T, I extends T> void writeNbt(Class<T> clazz, String name, I instance, CompoundNBT tag) {
        NBTClassType<I> serializationClass = NBTClassType.getClassType(clazz);
        if (serializationClass == null) {
            throw new RuntimeException("No valid NBT serialization was found for " + instance + " of type " + clazz);
        }
        serializationClass.writePersistedField(name, instance, tag);
    }

    public static <T> T readNbt(Class<T> clazz, String name, CompoundNBT tag) {
        NBTClassType<T> serializationClass = NBTClassType.getClassType(clazz);
        if (serializationClass == null) {
            throw new RuntimeException("No valid NBT serialization was found type " + clazz);
        }
        return serializationClass.readPersistedField(name, tag);
    }

    private static boolean isImplementsInterface(Class<?> clazz, Class<?> interfaceClazz) {
        return interfaceClazz.isAssignableFrom(clazz);
    }

    private static NBTClassType getTypeSilent(Class<?> type) {
        NBTClassType<?> action = NBTYPES.get(type);
        if (action == null) {
            for (Class<?> iface : type.getInterfaces()) {
                action = NBTYPES.get(iface);
                if (action == null) continue;
                return action;
            }
            Class<?> superClass = type.getSuperclass();
            if (superClass != null) {
                return NBTClassType.getTypeSilent(superClass);
            }
            return null;
        }
        return action;
    }

    public static NBTClassType getType(Class<?> type, Object target) {
        if (NBTClassType.isImplementsInterface(type, INBTSerializable.class)) {
            return new INBTSerializable.SelfNBTClassType(type);
        }
        NBTClassType action = NBTClassType.getTypeSilent(type);
        if (action == null) {
            throw new RuntimeException("No NBT persist action found for type " + type.getName() + " or any of its parents and interfaces in class " + target.getClass() + " for target object " + target + ".");
        }
        return action;
    }

    public static void performActionForField(INBTProvider provider, Field field, CompoundNBT tag, boolean write) {
        Class<?> type = field.getType();
        String fieldName = field.getName();
        boolean wasAccessible = field.isAccessible();
        if (!wasAccessible) {
            try {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
            field.setAccessible(true);
        }
        NBTClassType action = NBTClassType.getType(type, provider);
        try {
            action.persistedFieldAction(provider, field, tag, write);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not access field " + fieldName + " in " + provider.getClass() + " " + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void persistedFieldAction(INBTProvider provider, Field field, CompoundNBT tag, boolean write) throws IllegalAccessException {
        String name = field.getName();
        NBTPersist annotation = field.getAnnotation(NBTPersist.class);
        boolean useDefaultValue = annotation.useDefaultValue();
        Object castTile = field.getDeclaringClass().cast(provider);
        if (write) {
            try {
                field.setAccessible(true);
                Object object = field.get(castTile);
                if (object == null) return;
                try {
                    this.writePersistedField(name, object, tag);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("Something went from with the field " + field.getName() + " in " + castTile + ": " + e.getMessage());
                }
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Can not write the field " + field.getName() + " in " + castTile + " since it does not exist. " + e.getMessage());
            }
        }
        Object object = null;
        try {
            if (tag.func_74764_b(name)) {
                object = this.readPersistedField(name, tag);
                field.setAccessible(true);
                field.set(castTile, object);
                return;
            } else {
                if (!useDefaultValue) return;
                object = this.getDefaultValue();
                field.setAccessible(true);
                field.set(castTile, object);
            }
            return;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("Can not read the field " + field.getName() + " as " + object + " in " + castTile + " since it does not exist OR there is a class mismatch. " + e.getMessage());
        }
    }

    public abstract void writePersistedField(String var1, T var2, CompoundNBT var3);

    public abstract T readPersistedField(String var1, CompoundNBT var2);

    public abstract T getDefaultValue();

    static {
        NBTYPES.put(Integer.class, new NBTClassType<Integer>(){

            @Override
            public void writePersistedField(String name, Integer object, CompoundNBT tag) {
                tag.func_74768_a(name, object.intValue());
            }

            @Override
            public Integer readPersistedField(String name, CompoundNBT tag) {
                return tag.func_74762_e(name);
            }

            @Override
            public Integer getDefaultValue() {
                return 0;
            }
        });
        NBTYPES.put(Integer.TYPE, NBTYPES.get(Integer.class));
        NBTYPES.put(Float.class, new NBTClassType<Float>(){

            @Override
            public void writePersistedField(String name, Float object, CompoundNBT tag) {
                tag.func_74776_a(name, object.floatValue());
            }

            @Override
            public Float readPersistedField(String name, CompoundNBT tag) {
                return Float.valueOf(tag.func_74760_g(name));
            }

            @Override
            public Float getDefaultValue() {
                return Float.valueOf(0.0f);
            }
        });
        NBTYPES.put(Float.TYPE, NBTYPES.get(Float.class));
        NBTYPES.put(Boolean.class, new NBTClassType<Boolean>(){

            @Override
            public void writePersistedField(String name, Boolean object, CompoundNBT tag) {
                tag.func_74757_a(name, object.booleanValue());
            }

            @Override
            public Boolean readPersistedField(String name, CompoundNBT tag) {
                return tag.func_74767_n(name);
            }

            @Override
            public Boolean getDefaultValue() {
                return false;
            }
        });
        NBTYPES.put(Boolean.TYPE, NBTYPES.get(Boolean.class));
        NBTYPES.put(String.class, new NBTClassType<String>(){

            @Override
            public void writePersistedField(String name, String object, CompoundNBT tag) {
                if (object != null && !object.isEmpty()) {
                    tag.func_74778_a(name, object);
                }
            }

            @Override
            public String readPersistedField(String name, CompoundNBT tag) {
                return tag.func_74779_i(name);
            }

            @Override
            public String getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Direction.class, new NBTClassType<Direction>(){

            @Override
            public void writePersistedField(String name, Direction object, CompoundNBT tag) {
                tag.func_74768_a(name, object.ordinal());
            }

            @Override
            public Direction readPersistedField(String name, CompoundNBT tag) {
                return Direction.values()[tag.func_74762_e(name)];
            }

            @Override
            public Direction getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Fluid.class, new NBTClassType<Fluid>(){

            @Override
            public void writePersistedField(String name, Fluid object, CompoundNBT tag) {
                tag.func_74778_a(name, object.getRegistryName().toString());
            }

            @Override
            public Fluid readPersistedField(String name, CompoundNBT tag) {
                String fluidName = tag.func_74779_i(name);
                return (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
            }

            @Override
            public Fluid getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(FluidStack.class, new NBTClassType<FluidStack>(){

            @Override
            public void writePersistedField(String name, @Nullable FluidStack object, CompoundNBT tag) {
                if (object != null) {
                    CompoundNBT subTag = new CompoundNBT();
                    object.writeToNBT(subTag);
                    tag.func_218657_a(name, (INBT)subTag);
                }
            }

            @Override
            public FluidStack readPersistedField(String name, CompoundNBT tag) {
                return FluidStack.loadFluidStackFromNBT((CompoundNBT)tag.func_74775_l(name));
            }

            @Override
            public FluidStack getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(CompoundNBT.class, new NBTClassType<CompoundNBT>(){

            @Override
            public void writePersistedField(String name, CompoundNBT object, CompoundNBT tag) {
                tag.func_218657_a(name, (INBT)object);
            }

            @Override
            public CompoundNBT readPersistedField(String name, CompoundNBT tag) {
                return tag.func_74775_l(name);
            }

            @Override
            public CompoundNBT getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Set.class, new CollectionNBTClassType<Set>(){

            @Override
            protected Set createNewCollection() {
                return Sets.newHashSet();
            }
        });
        NBTYPES.put(List.class, new CollectionNBTClassType<List>(){

            @Override
            protected List createNewCollection() {
                return Lists.newLinkedList();
            }
        });
        NBTYPES.put(Map.class, new NBTClassType<Map>(){

            @Override
            public void writePersistedField(String name, Map object, CompoundNBT tag) {
                CompoundNBT mapTag = new CompoundNBT();
                ListNBT list = new ListNBT();
                boolean setKeyType = false;
                boolean setValueType = false;
                for (Map.Entry entry : object.entrySet()) {
                    CompoundNBT entryTag = new CompoundNBT();
                    11.getType(entry.getKey().getClass(), object).writePersistedField("key", entry.getKey(), entryTag);
                    if (entry.getValue() != null) {
                        11.getType(entry.getValue().getClass(), object).writePersistedField("value", entry.getValue(), entryTag);
                    }
                    list.add((Object)entryTag);
                    if (!setKeyType) {
                        setKeyType = true;
                        mapTag.func_74778_a("keyType", entry.getKey().getClass().getName());
                    }
                    if (setValueType || entry.getValue() == null) continue;
                    setValueType = true;
                    mapTag.func_74778_a("valueType", entry.getValue().getClass().getName());
                }
                mapTag.func_218657_a("map", (INBT)list);
                tag.func_218657_a(name, (INBT)mapTag);
            }

            @Override
            public Map readPersistedField(String name, CompoundNBT tag) {
                CompoundNBT mapTag = tag.func_74775_l(name);
                HashMap map = Maps.newHashMap();
                ListNBT list = mapTag.func_150295_c("map", 10);
                if (list.size() > 0) {
                    NBTClassType keyNBTClassType;
                    NBTClassType valueNBTClassType = null;
                    try {
                        Class<?> keyType = Class.forName(mapTag.func_74779_i("keyType"));
                        keyNBTClassType = 11.getType(keyType, map);
                    }
                    catch (ClassNotFoundException e) {
                        CyclopsCore.clog(Level.WARN, "No class found for NBT type map key '" + mapTag.func_74779_i("keyType") + "', this could be a mod error.");
                        return map;
                    }
                    if (mapTag.func_74764_b("valueType")) {
                        try {
                            Class<?> valueType = Class.forName(mapTag.func_74779_i("valueType"));
                            valueNBTClassType = 11.getType(valueType, map);
                        }
                        catch (ClassNotFoundException e) {
                            CyclopsCore.clog(Level.WARN, "No class found for NBT type map value '" + mapTag.func_74779_i("valueType") + "', this could be a mod error.");
                            return map;
                        }
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        CompoundNBT entryTag = list.func_150305_b(i);
                        Object key = keyNBTClassType.readPersistedField("key", entryTag);
                        Object value = null;
                        if (valueNBTClassType != null && entryTag.func_74764_b("value")) {
                            value = valueNBTClassType.readPersistedField("value", entryTag);
                        }
                        map.put(key, value);
                    }
                }
                return map;
            }

            @Override
            public Map getDefaultValue() {
                return Maps.newHashMap();
            }
        });
        NBTYPES.put(Vec3i.class, new NBTClassType<Vec3i>(){

            @Override
            public void writePersistedField(String name, Vec3i object, CompoundNBT tag) {
                tag.func_74783_a(name, new int[]{object.func_177958_n(), object.func_177956_o(), object.func_177952_p()});
            }

            @Override
            public Vec3i readPersistedField(String name, CompoundNBT tag) {
                int[] array = tag.func_74759_k(name);
                return new Vec3i(array[0], array[1], array[2]);
            }

            @Override
            public Vec3i getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Vec3d.class, new NBTClassType<Vec3d>(){

            @Override
            public void writePersistedField(String name, Vec3d object, CompoundNBT tag) {
                CompoundNBT vec = new CompoundNBT();
                vec.func_74780_a("x", object.field_72450_a);
                vec.func_74780_a("y", object.field_72448_b);
                vec.func_74780_a("z", object.field_72449_c);
                tag.func_218657_a(name, (INBT)vec);
            }

            @Override
            public Vec3d readPersistedField(String name, CompoundNBT tag) {
                CompoundNBT vec = tag.func_74775_l(name);
                return new Vec3d(vec.func_74769_h("x"), vec.func_74769_h("y"), vec.func_74769_h("z"));
            }

            @Override
            public Vec3d getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Pair.class, new NBTClassType<Pair>(){

            @Override
            public void writePersistedField(String name, Pair object, CompoundNBT tag) {
                CompoundNBT pairTag = new CompoundNBT();
                CompoundNBT leftTag = new CompoundNBT();
                CompoundNBT rightTag = new CompoundNBT();
                14.getType(object.getLeft().getClass(), object).writePersistedField("element", object.getLeft(), leftTag);
                14.getType(object.getRight().getClass(), object).writePersistedField("element", object.getRight(), rightTag);
                pairTag.func_74778_a("leftType", object.getLeft().getClass().getName());
                pairTag.func_74778_a("rightType", object.getRight().getClass().getName());
                pairTag.func_218657_a("left", (INBT)leftTag);
                pairTag.func_218657_a("right", (INBT)rightTag);
                tag.func_218657_a(name, (INBT)pairTag);
            }

            @Override
            public Pair readPersistedField(String name, CompoundNBT tag) {
                NBTClassType rightElementNBTClassType;
                NBTClassType leftElementNBTClassType;
                CompoundNBT pairTag = tag.func_74775_l(name);
                CompoundNBT leftTag = pairTag.func_74775_l("left");
                CompoundNBT rightTag = pairTag.func_74775_l("right");
                try {
                    Class<?> elementType = Class.forName(pairTag.func_74779_i("leftType"));
                    leftElementNBTClassType = 14.getType(elementType, Pair.class);
                }
                catch (ClassNotFoundException e) {
                    CyclopsCore.clog(Level.WARN, "No class found for NBT type Pair left element '" + pairTag.func_74779_i("leftType") + "', this could be a mod error.");
                    return Pair.of(null, null);
                }
                try {
                    Class<?> elementType = Class.forName(pairTag.func_74779_i("rightType"));
                    rightElementNBTClassType = 14.getType(elementType, Pair.class);
                }
                catch (ClassNotFoundException e) {
                    CyclopsCore.clog(Level.WARN, "No class found for NBT type Pair right element '" + pairTag.func_74779_i("rightType") + "', this could be a mod error.");
                    return Pair.of(null, null);
                }
                Object left = leftElementNBTClassType.readPersistedField("element", leftTag);
                Object right = rightElementNBTClassType.readPersistedField("element", rightTag);
                return Pair.of(left, right);
            }

            @Override
            public Pair getDefaultValue() {
                return Pair.of(null, null);
            }
        });
        NBTYPES.put(DimPos.class, new NBTClassType<DimPos>(){

            @Override
            public void writePersistedField(String name, DimPos object, CompoundNBT tag) {
                CompoundNBT dimPos = new CompoundNBT();
                dimPos.func_74778_a("dim", object.getDimension().getRegistryName().toString());
                dimPos.func_74768_a("x", object.getBlockPos().func_177958_n());
                dimPos.func_74768_a("y", object.getBlockPos().func_177956_o());
                dimPos.func_74768_a("z", object.getBlockPos().func_177952_p());
                tag.func_218657_a(name, (INBT)dimPos);
            }

            @Override
            public DimPos readPersistedField(String name, CompoundNBT tag) {
                CompoundNBT dimPos = tag.func_74775_l(name);
                String dimensionName = dimPos.func_74779_i("dim");
                Optional dimensionType = Registry.field_212622_k.func_218349_b(new ResourceLocation(dimensionName));
                if (!dimensionType.isPresent()) {
                    CyclopsCore.clog(Level.WARN, String.format("Could not find dimension %s", dimensionName));
                }
                return DimPos.of(dimensionType.orElse(DimensionType.field_223227_a_), new BlockPos(dimPos.func_74762_e("x"), dimPos.func_74762_e("y"), dimPos.func_74762_e("z")));
            }

            @Override
            public DimPos getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(ItemStack.class, new NBTClassType<ItemStack>(){

            @Override
            public void writePersistedField(String name, ItemStack object, CompoundNBT tag) {
                if (object != null) {
                    tag.func_218657_a(name, (INBT)object.func_77946_l().func_77955_b(new CompoundNBT()));
                }
            }

            @Override
            public ItemStack readPersistedField(String name, CompoundNBT tag) {
                return ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(name));
            }

            @Override
            public ItemStack getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(EnumFacingMap.class, new NBTClassType<EnumFacingMap>(){

            @Override
            public void writePersistedField(String name, EnumFacingMap object, CompoundNBT tag) {
                CompoundNBT mapTag = new CompoundNBT();
                ListNBT list = new ListNBT();
                boolean setValueType = false;
                for (Map.Entry entry : object.entrySet()) {
                    CompoundNBT entryTag = new CompoundNBT();
                    entryTag.func_74768_a("key", ((Direction)entry.getKey()).ordinal());
                    if (entry.getValue() != null) {
                        17.getType(entry.getValue().getClass(), object).writePersistedField("value", entry.getValue(), entryTag);
                    }
                    list.add((Object)entryTag);
                    if (setValueType || entry.getValue() == null) continue;
                    setValueType = true;
                    mapTag.func_74778_a("valueType", entry.getValue().getClass().getName());
                }
                mapTag.func_218657_a("map", (INBT)list);
                tag.func_218657_a(name, (INBT)mapTag);
            }

            @Override
            public EnumFacingMap readPersistedField(String name, CompoundNBT tag) {
                CompoundNBT mapTag = tag.func_74775_l(name);
                EnumFacingMap<Object> map = EnumFacingMap.newMap();
                ListNBT list = mapTag.func_150295_c("map", 10);
                if (list.size() > 0) {
                    NBTClassType valueNBTClassType = null;
                    if (mapTag.func_74764_b("valueType")) {
                        try {
                            Class<?> valueType = Class.forName(mapTag.func_74779_i("valueType"));
                            valueNBTClassType = 17.getType(valueType, map);
                        }
                        catch (ClassNotFoundException e) {
                            CyclopsCore.clog(Level.WARN, "No class found for NBT type map value '" + mapTag.func_74779_i("valueType") + "', this could be a mod error.");
                            return map;
                        }
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        CompoundNBT entryTag = list.func_150305_b(i);
                        Direction key = Direction.values()[entryTag.func_74762_e("key")];
                        Object value = null;
                        if (valueNBTClassType != null && entryTag.func_74764_b("value")) {
                            value = valueNBTClassType.readPersistedField("value", entryTag);
                        }
                        map.put(key, value);
                    }
                }
                return map;
            }

            @Override
            public EnumFacingMap getDefaultValue() {
                return EnumFacingMap.newMap();
            }
        });
    }

    private static abstract class CollectionNBTClassType<C extends Collection>
    extends NBTClassType<C> {
        private CollectionNBTClassType() {
        }

        protected abstract C createNewCollection();

        @Override
        public C getDefaultValue() {
            return this.createNewCollection();
        }

        @Override
        public void writePersistedField(String name, C object, CompoundNBT tag) {
            CompoundNBT collectionTag = new CompoundNBT();
            ListNBT list = new ListNBT();
            boolean setTypes = false;
            for (Object element : object) {
                CompoundNBT elementTag = new CompoundNBT();
                CollectionNBTClassType.getType(element.getClass(), object).writePersistedField("element", element, elementTag);
                list.add((Object)elementTag);
                if (setTypes) continue;
                setTypes = true;
                collectionTag.func_74778_a("elementType", element.getClass().getName());
            }
            collectionTag.func_218657_a("collection", (INBT)list);
            tag.func_218657_a(name, (INBT)collectionTag);
        }

        @Override
        public C readPersistedField(String name, CompoundNBT tag) {
            CompoundNBT collectionTag = tag.func_74775_l(name);
            C collection = this.createNewCollection();
            ListNBT list = collectionTag.func_150295_c("collection", 10);
            if (list.size() > 0) {
                NBTClassType elementNBTClassType;
                try {
                    Class<?> elementType = Class.forName(collectionTag.func_74779_i("elementType"));
                    elementNBTClassType = CollectionNBTClassType.getType(elementType, collection);
                }
                catch (ClassNotFoundException e) {
                    CyclopsCore.clog(Level.WARN, "No class found for NBT type collection element '" + collectionTag.func_74779_i("elementType") + "', this could be a mod error.");
                    return collection;
                }
                for (int i = 0; i < list.size(); ++i) {
                    CompoundNBT entryTag = list.func_150305_b(i);
                    Object element = elementNBTClassType.readPersistedField("element", entryTag);
                    collection.add(element);
                }
            }
            return collection;
        }
    }
}

