/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import org.cyclops.cyclopscore.algorithm.Dimension;
import org.cyclops.cyclopscore.block.multi.AllowedBlock;
import org.cyclops.cyclopscore.block.multi.DetectionResult;
import org.cyclops.cyclopscore.block.multi.IBlockCountValidator;
import org.cyclops.cyclopscore.block.multi.ISizeValidator;
import org.cyclops.cyclopscore.helper.LocationHelpers;

public class CubeDetector {
    private static Vec3i NULL_SIZE = Vec3i.field_177959_e;
    private Collection<AllowedBlock> allowedBlocks = Sets.newHashSet();
    private Map<Block, AllowedBlock> blockInfo = Maps.newHashMap();
    private List<? extends IDetectionListener> listeners;
    private List<ISizeValidator> sizeValidators = Lists.newLinkedList();
    private final Map<Block, Integer> blockOccurences = Maps.newHashMap();

    public CubeDetector(AllowedBlock[] allowedBlocks, List<? extends IDetectionListener> listeners) {
        this.addAllowedBlocks(allowedBlocks);
        this.listeners = listeners;
    }

    public Collection<AllowedBlock> getAllowedBlocks() {
        return this.allowedBlocks;
    }

    public void addAllowedBlocks(AllowedBlock[] allowedBlocks) {
        for (AllowedBlock block : allowedBlocks) {
            this.blockInfo.put(block.getBlock(), block);
            this.allowedBlocks.add(block);
        }
    }

    public List<ISizeValidator> getSizeValidators() {
        return this.sizeValidators;
    }

    public CubeDetector addSizeValidator(ISizeValidator sizeValidator) {
        this.sizeValidators.add(sizeValidator);
        return this;
    }

    public List<? extends IDetectionListener> getListeners() {
        return this.listeners;
    }

    protected void notifyListeners(IWorldReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        for (IDetectionListener iDetectionListener : this.getListeners()) {
            iDetectionListener.onDetect(world, location, size, valid, originCorner);
        }
    }

    protected ITextComponent isValidLocation(IWorldReader world, BlockPos location, IValidationAction action, BlockPos excludeLocation) {
        ITextComponent error;
        boolean contains;
        BlockState blockState = world.func_180495_p(location);
        Block block = blockState.func_177230_c();
        boolean bl = contains = location.equals((Object)excludeLocation) || this.blockInfo.containsKey(block);
        if (action != null && this.blockInfo.containsKey(block) && (error = action.onValidate(location, blockState)) != null) {
            return error;
        }
        return contains ? null : new TranslationTextComponent("multiblock.cyclopscore.error.invalidBlock", new Object[]{LocationHelpers.toCompactString(location), new TranslationTextComponent(block.func_149739_a(), new Object[0])});
    }

    protected ITextComponent isValidLocation(IWorldReader world, BlockPos location, BlockPos excludeLocation) {
        return this.isValidLocation(world, location, null, excludeLocation);
    }

    protected boolean isAir(IWorldReader world, BlockPos location) {
        return world.func_175623_d(location);
    }

    protected BlockPos navigateToBorder(IWorldReader world, BlockPos startLocation, int dimension, int direction, BlockPos excludeLocation) {
        BlockPos loopLocation = LocationHelpers.copyLocation(startLocation);
        while (this.isValidLocation(world, loopLocation, excludeLocation) == null) {
            loopLocation = LocationHelpers.addToDimension(loopLocation, dimension, direction);
        }
        loopLocation = LocationHelpers.addToDimension(loopLocation, dimension, -direction);
        return loopLocation;
    }

    protected BlockPos navigateToBorder(IWorldReader world, BlockPos startLocation, int dimension, boolean max, BlockPos excludeLocation) {
        return this.navigateToBorder(world, startLocation, dimension, max ? 1 : -1, excludeLocation);
    }

    protected BlockPos navigateToCorner(IWorldReader world, BlockPos startLocation, int[] dimensions, boolean max, BlockPos excludeLocation) {
        BlockPos navigateLocation = LocationHelpers.copyLocation(startLocation);
        for (int dimension : dimensions) {
            navigateLocation = this.navigateToBorder(world, navigateLocation, dimension, max, excludeLocation);
        }
        return navigateLocation;
    }

    protected boolean isEdge(IWorldReader world, int[][] dimensionEgdes, BlockPos location) {
        int[] c = LocationHelpers.toArray((Vec3i)location);
        for (int i = 0; i < dimensionEgdes.length; ++i) {
            for (int j = 0; j < dimensionEgdes[i].length; ++j) {
                if (dimensionEgdes[i][j] != c[i]) continue;
                return true;
            }
        }
        return false;
    }

    protected ITextComponent validateLocationInStructure(IWorldReader world, int[][] dimensionEgdes, BlockPos location, IValidationAction action, BlockPos excludeLocation) {
        return this.isValidLocation(world, location, action, excludeLocation);
    }

    protected boolean coordinateRecursion(IWorldReader world, int[][] dimensionEgdes, BlockPosAction locationAction) {
        return this.coordinateRecursion(world, dimensionEgdes, new int[0], locationAction);
    }

    protected boolean coordinateRecursion(IWorldReader world, int[][] dimensionEgdes, int[] accumulatedCoordinates, BlockPosAction locationAction) {
        if (accumulatedCoordinates.length == dimensionEgdes.length) {
            BlockPos location = LocationHelpers.fromArray(accumulatedCoordinates);
            if (!locationAction.run(world, location)) {
                return false;
            }
        } else {
            int dimension = accumulatedCoordinates.length;
            int i = dimensionEgdes[dimension][0];
            while (i <= dimensionEgdes[dimension][1]) {
                int[] newAccumulatedCoordinates = Arrays.copyOf(accumulatedCoordinates, accumulatedCoordinates.length + 1);
                newAccumulatedCoordinates[accumulatedCoordinates.length] = i++;
                if (this.coordinateRecursion(world, dimensionEgdes, newAccumulatedCoordinates, locationAction)) continue;
                return false;
            }
        }
        return true;
    }

    protected ITextComponent validateAllowedBlockConditions(IWorldReader world, BlockPos location) {
        Block block = world.func_180495_p(location).func_177230_c();
        if (this.blockInfo.containsKey(block)) {
            Integer occurences = this.blockOccurences.get(block);
            if (occurences == null) {
                occurences = 0;
            }
            AllowedBlock allowed = this.blockInfo.get(block);
            for (IBlockCountValidator validator : allowed.getCountValidators()) {
                ITextComponent error = validator.isValid(occurences, false, allowed.getBlock());
                if (error == null) continue;
                return error;
            }
            this.blockOccurences.put(block, occurences + 1);
        }
        return null;
    }

    protected ITextComponent validateDimensionEdges(IWorldReader world, final int[][] dimensionEgdes, final boolean valid, final IValidationAction action, final BlockPos excludeLocation) {
        this.blockOccurences.clear();
        for (AllowedBlock block : this.allowedBlocks) {
            this.blockOccurences.put(block.getBlock(), 0);
        }
        final LinkedList errors = Lists.newLinkedList();
        boolean minimumValid = this.coordinateRecursion(world, dimensionEgdes, new BlockPosAction(){

            @Override
            public boolean run(IWorldReader world, BlockPos location) {
                if (!valid) {
                    return true;
                }
                ITextComponent allowedBlocks = CubeDetector.this.validateAllowedBlockConditions(world, location);
                ITextComponent allowedLocation = CubeDetector.this.validateLocationInStructure(world, dimensionEgdes, location, action, excludeLocation);
                if (allowedBlocks != null) {
                    errors.add(allowedBlocks);
                }
                if (allowedLocation != null) {
                    errors.add(allowedLocation);
                }
                return allowedBlocks == null && allowedLocation == null;
            }
        });
        if (minimumValid) {
            for (AllowedBlock allowed : this.allowedBlocks) {
                int occurences = this.blockOccurences.getOrDefault(allowed.getBlock(), 0);
                for (IBlockCountValidator validator : allowed.getCountValidators()) {
                    ITextComponent error = validator.isValid(occurences, true, allowed.getBlock());
                    if (error == null) continue;
                    return valid ? error : null;
                }
            }
        }
        return minimumValid ? null : (errors.isEmpty() ? null : (ITextComponent)errors.get(0));
    }

    protected void postValidate(IWorldReader world, final Vec3i size, int[][] dimensionEgdes, final boolean valid, final BlockPos originCorner, BlockPos excludeLocation) {
        this.coordinateRecursion(world, dimensionEgdes, new BlockPosAction(){

            @Override
            public boolean run(IWorldReader world, BlockPos location) {
                CubeDetector.this.notifyListeners(world, location, size, valid, originCorner);
                return true;
            }
        });
    }

    public DetectionResult detect(IWorldReader world, BlockPos startLocation, BlockPos excludeLocation, boolean changeState) {
        return this.detect(world, startLocation, excludeLocation, null, changeState);
    }

    public DetectionResult detect(IWorldReader world, BlockPos startLocation, BlockPos excludeLocation, IValidationAction action, boolean changeState) {
        ITextComponent error = this.isValidLocation(world, startLocation, excludeLocation);
        if (error != null) {
            return new DetectionResult(error);
        }
        BlockPos tempOriginCorner = this.navigateToCorner(world, startLocation, new int[]{2, 1, 0}, true, excludeLocation);
        BlockPos originCorner = this.navigateToCorner(world, tempOriginCorner, new int[]{0, 1, 2}, false, excludeLocation);
        BlockPos[] corners = new BlockPos[Dimension.DIMENSIONS.length];
        for (int i = 0; i < corners.length; ++i) {
            corners[i] = this.navigateToCorner(world, originCorner, new int[]{i}, true, excludeLocation);
        }
        int[] distances = new int[corners.length];
        int[][] dimensionEgdes = new int[corners.length][2];
        int[] cOriginCorner = LocationHelpers.toArray((Vec3i)originCorner);
        for (int i = 0; i < corners.length; ++i) {
            int[] cCorner = LocationHelpers.toArray((Vec3i)corners[i]);
            BlockPos sizeDifference = LocationHelpers.subtract(corners[i], (Vec3i)originCorner);
            distances[i] = LocationHelpers.toArray((Vec3i)sizeDifference)[i];
            int addIndex = 0;
            if (cOriginCorner[i] > cCorner[i]) {
                addIndex = 1;
            }
            dimensionEgdes[i][(0 + addIndex) % 2] = cOriginCorner[i];
            dimensionEgdes[i][(1 + addIndex) % 2] = cCorner[i];
        }
        error = this.validateDimensionEdges(world, dimensionEgdes, excludeLocation == null, action, excludeLocation);
        if (error != null) {
            return new DetectionResult(error);
        }
        BlockPos size = LocationHelpers.fromArray(distances);
        for (ISizeValidator validator : this.getSizeValidators()) {
            error = validator.isSizeValid((Vec3i)size);
            if (error == null || excludeLocation != null) continue;
            return new DetectionResult(error);
        }
        if (changeState) {
            this.postValidate(world, (Vec3i)size, dimensionEgdes, excludeLocation == null, originCorner, excludeLocation);
        }
        return new DetectionResult((Vec3i)size);
    }

    public static interface IValidationAction {
        public ITextComponent onValidate(BlockPos var1, BlockState var2);
    }

    protected static interface BlockPosAction {
        public boolean run(IWorldReader var1, BlockPos var2);
    }

    public static interface IDetectionListener {
        public void onDetect(IWorldReader var1, BlockPos var2, Vec3i var3, boolean var4, BlockPos var5);
    }
}

