/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import org.cyclops.cyclopscore.block.multi.AllowedBlock;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.helper.LocationHelpers;

public class HollowCubeDetector
extends CubeDetector {
    public HollowCubeDetector(AllowedBlock[] allowedBlocks, List<? extends CubeDetector.IDetectionListener> listeners) {
        super(allowedBlocks, listeners);
    }

    @Override
    protected void postValidate(IWorldReader world, final Vec3i size, final int[][] dimensionEgdes, final boolean valid, final BlockPos originCorner, final BlockPos excludeLocation) {
        this.coordinateRecursion(world, dimensionEgdes, new CubeDetector.BlockPosAction(){

            @Override
            public boolean run(IWorldReader world, BlockPos location) {
                if (HollowCubeDetector.this.isEdge(world, dimensionEgdes, location) && HollowCubeDetector.this.isValidLocation(world, location, excludeLocation) == null) {
                    HollowCubeDetector.this.notifyListeners(world, location, size, valid, originCorner);
                }
                return true;
            }
        });
    }

    @Override
    protected ITextComponent validateLocationInStructure(IWorldReader world, int[][] dimensionEgdes, BlockPos location, CubeDetector.IValidationAction action, BlockPos excludeLocation) {
        if (this.isEdge(world, dimensionEgdes, location)) {
            ITextComponent error = this.isValidLocation(world, location, action, excludeLocation);
            if (error != null) {
                return error;
            }
        } else if (!this.isAir(world, location)) {
            return new TranslationTextComponent("multiblock.cyclopscore.error.hollow.air", new Object[]{LocationHelpers.toCompactString(location)});
        }
        return null;
    }
}

