/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.image;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.helper.RenderHelpers;

public class Image
implements IImage {
    private final ResourceLocation resourceLocation;
    private final int sheetX;
    private final int sheetY;
    private final int sheetWidth;
    private final int sheetHeight;

    public Image(ResourceLocation resourceLocation, int sheetX, int sheetY, int sheetWidth, int sheetHeight) {
        this.resourceLocation = resourceLocation;
        this.sheetX = sheetX;
        this.sheetY = sheetY;
        this.sheetWidth = sheetWidth;
        this.sheetHeight = sheetHeight;
    }

    @Override
    public void draw(AbstractGui gui, int x, int y) {
        RenderHelpers.bindTexture(this.resourceLocation);
        gui.blit(x, y, this.sheetX, this.sheetY, this.sheetWidth, this.sheetHeight);
    }

    @Override
    public void drawWorldWithAlpha(TextureManager textureManager, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay, float x1, float x2, float y1, float y2, float z, float alpha) {
        matrixStack.func_227860_a_();
        IVertexBuilder vb = renderTypeBuffer.getBuffer(RenderType.func_228658_l_((ResourceLocation)this.getResourceLocation()));
        float u1 = (float)this.getSheetX() / 256.0f;
        float u2 = (float)(this.getSheetX() + this.getSheetWidth()) / 256.0f;
        float v1 = (float)this.getSheetY() / 256.0f;
        float v2 = (float)(this.getSheetY() + this.getSheetHeight()) / 256.0f;
        int a = Math.round(alpha * 255.0f);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        vb.func_227888_a_(matrix, x2, y2, z).func_225586_a_(255, 255, 255, a).func_225583_a_(u2, v2).func_227886_a_(combinedLight).func_181675_d();
        vb.func_227888_a_(matrix, x2, y1, z).func_225586_a_(255, 255, 255, a).func_225583_a_(u2, v1).func_227886_a_(combinedLight).func_181675_d();
        vb.func_227888_a_(matrix, x1, y1, z).func_225586_a_(255, 255, 255, a).func_225583_a_(u1, v1).func_227886_a_(combinedLight).func_181675_d();
        vb.func_227888_a_(matrix, x1, y2, z).func_225586_a_(255, 255, 255, a).func_225583_a_(u1, v2).func_227886_a_(combinedLight).func_181675_d();
        matrixStack.func_227865_b_();
    }

    @Override
    public int getWidth() {
        return this.sheetWidth;
    }

    @Override
    public int getHeight() {
        return this.sheetHeight;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public int getSheetX() {
        return this.sheetX;
    }

    public int getSheetY() {
        return this.sheetY;
    }

    public int getSheetWidth() {
        return this.sheetWidth;
    }

    public int getSheetHeight() {
        return this.sheetHeight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Image)) {
            return false;
        }
        Image other = (Image)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResourceLocation this$resourceLocation = this.getResourceLocation();
        ResourceLocation other$resourceLocation = other.getResourceLocation();
        if (this$resourceLocation == null ? other$resourceLocation != null : !this$resourceLocation.equals(other$resourceLocation)) {
            return false;
        }
        if (this.getSheetX() != other.getSheetX()) {
            return false;
        }
        if (this.getSheetY() != other.getSheetY()) {
            return false;
        }
        if (this.getSheetWidth() != other.getSheetWidth()) {
            return false;
        }
        return this.getSheetHeight() == other.getSheetHeight();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Image;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResourceLocation $resourceLocation = this.getResourceLocation();
        result = result * 59 + ($resourceLocation == null ? 0 : $resourceLocation.hashCode());
        result = result * 59 + this.getSheetX();
        result = result * 59 + this.getSheetY();
        result = result * 59 + this.getSheetWidth();
        result = result * 59 + this.getSheetHeight();
        return result;
    }

    public String toString() {
        return "Image(resourceLocation=" + this.getResourceLocation() + ", sheetX=" + this.getSheetX() + ", sheetY=" + this.getSheetY() + ", sheetWidth=" + this.getSheetWidth() + ", sheetHeight=" + this.getSheetHeight() + ")";
    }
}

