/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.RegistryEntries;

public class ParticleDropColoredData
implements IParticleData {
    public static final ParticleDropColoredData INSTANCE = new ParticleDropColoredData(0.0f, 0.0f, 0.0f);
    public static final IParticleData.IDeserializer<ParticleDropColoredData> DESERIALIZER = new IParticleData.IDeserializer<ParticleDropColoredData>(){

        public ParticleDropColoredData deserialize(ParticleType<ParticleDropColoredData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float red = (float)reader.readDouble();
            reader.expect(' ');
            float green = (float)reader.readDouble();
            reader.expect(' ');
            float blue = (float)reader.readDouble();
            return new ParticleDropColoredData(red, green, blue);
        }

        public ParticleDropColoredData read(ParticleType<ParticleDropColoredData> particleTypeIn, PacketBuffer buffer) {
            return new ParticleDropColoredData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    private final float red;
    private final float green;
    private final float blue;

    public ParticleDropColoredData(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public ParticleType<?> func_197554_b() {
        return RegistryEntries.PARTICLE_DROP_COLORED;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.func_197554_b()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }
}

