/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.event;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.network.packet.RingOfFirePacket;

public class PlayerRingOfFire {
    public static final Set<UUID> ALLOW_RING = new HashSet<UUID>();

    @SubscribeEvent
    public void onLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        this.spawnRing(event.getPlayer());
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.spawnRing(event.getPlayer());
    }

    private void spawnRing(PlayerEntity player) {
        if (!player.field_70170_p.func_201670_d() && player.func_146103_bH() != null && ALLOW_RING.contains(player.func_146103_bH().getId())) {
            CyclopsCore._instance.getPacketHandler().sendToAllAround(new RingOfFirePacket(player), LocationHelpers.createTargetPointFromLocation((IWorldReader)player.field_70170_p, player.func_180425_c(), 50));
        }
    }

    static {
        ALLOW_RING.add(UUID.fromString("068d4de0-3a75-4c6a-9f01-8c37e16a394c"));
        ALLOW_RING.add(UUID.fromString("e1dc75c6-dcf9-4e0c-8fbf-9c6e5e44527c"));
        ALLOW_RING.add(UUID.fromString("3e13f558-fb72-4949-a842-07879924bc49"));
        ALLOW_RING.add(UUID.fromString("777e7aa3-9373-4511-8d75-f99d23ebe252"));
        ALLOW_RING.add(UUID.fromString("94b8bfe7-9102-405c-ab80-2c4468e918f9"));
    }
}

