/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;

public class EntityHelpers {
    public static final String NBTTAG_ID = "id";

    public static void onEntityCollided(World world, BlockPos blockPos, Entity entity) {
        if (blockPos != null) {
            Block block = world.func_180495_p(blockPos).func_177230_c();
            block.func_176199_a(world, blockPos, entity);
        }
    }

    public static List<Entity> getEntitiesInArea(World world, BlockPos blockPos, int area) {
        AxisAlignedBB box = new AxisAlignedBB((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()).func_72314_b((double)area, (double)area, (double)area);
        List entities = world.func_217357_a(Entity.class, box);
        return entities;
    }

    public static Optional<Entity> spawnEntity(World world, @Nullable ResourceLocation entityName, double x, double y, double z) {
        return EntityType.func_220327_a((String)entityName.toString()).map(type -> {
            Entity entity = type.func_200721_a(world);
            entity.func_70107_b(x, y, z);
            world.func_217376_c(entity);
            return entity;
        });
    }

    public static boolean spawnEntity(final World world, final MobEntity entityLiving, SpawnReason spawnReason) {
        AbstractSpawner spawner = new AbstractSpawner(){

            public void func_98267_a(int id) {
            }

            public World func_98271_a() {
                return world;
            }

            public BlockPos func_177221_b() {
                return entityLiving.func_180425_c();
            }
        };
        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((MobEntity)entityLiving, (IWorld)world, (double)((float)entityLiving.func_226277_ct_()), (double)((float)entityLiving.func_226278_cu_()), (double)((float)entityLiving.func_226281_cx_()), (AbstractSpawner)spawner, (SpawnReason)spawnReason);
        if (!(canSpawn != Event.Result.ALLOW && canSpawn != Event.Result.DEFAULT || ForgeEventFactory.doSpecialSpawn((MobEntity)entityLiving, (World)world, (float)((float)entityLiving.func_226277_ct_()), (float)((float)entityLiving.func_226278_cu_()), (float)((float)entityLiving.func_226281_cx_()), (AbstractSpawner)spawner, (SpawnReason)spawnReason))) {
            world.func_217376_c((Entity)entityLiving);
            return true;
        }
        return false;
    }

    public static Vec3i getEntitySize(Entity entity) {
        int x = (int)Math.ceil(entity.func_213311_cf());
        int y = (int)Math.ceil(entity.func_213302_cg());
        int z = x;
        return new Vec3i(x, y, z);
    }

    public static void spawnXpAtPlayer(World world, PlayerEntity player, int xp) {
        if (!world.func_201670_d()) {
            while (xp > 0) {
                int current = ExperienceOrbEntity.func_70527_a((int)xp);
                xp -= current;
                world.func_217376_c((Entity)new ExperienceOrbEntity(world, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_() + 0.5, current));
            }
        }
    }

    public static CompoundNBT getPersistedPlayerNbt(PlayerEntity player) {
        CompoundNBT tag = player.getPersistentData();
        CompoundNBT persistedTag = tag.func_74775_l("PlayerPersisted");
        if (persistedTag == null) {
            persistedTag = new CompoundNBT();
            tag.func_218657_a("PlayerPersisted", (INBT)persistedTag);
        }
        return persistedTag;
    }
}

