/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacityConfig;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;

public final class FluidHelpers {
    public static final int BUCKET_VOLUME = 1000;

    public static int getAmount(FluidStack fluidStack) {
        return fluidStack.getAmount();
    }

    public static FluidStack copy(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return fluidStack.copy();
    }

    public static boolean canCompletelyFill(IFluidHandler source, IFluidHandler destination) {
        FluidStack drained = source.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        return !drained.isEmpty() && destination.fill(drained, IFluidHandler.FluidAction.SIMULATE) == drained.getAmount();
    }

    public static FluidStack getFluid(@Nullable IFluidHandler fluidHandler) {
        return fluidHandler != null ? fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE) : FluidStack.EMPTY;
    }

    public static boolean hasFluid(@Nullable IFluidHandler fluidHandler) {
        return !FluidHelpers.getFluid(fluidHandler).isEmpty();
    }

    public static int getCapacity(@Nullable IFluidHandler fluidHandler) {
        int capacity = 0;
        if (fluidHandler != null) {
            for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                capacity += fluidHandler.getTankCapacity(i);
            }
        }
        return capacity;
    }

    public static LazyOptional<IFluidHandlerItemCapacity> getFluidHandlerItemCapacity(ItemStack itemStack) {
        return itemStack.getCapability(FluidHandlerItemCapacityConfig.CAPABILITY);
    }

    public static FluidStack extractFromInventory(int amount, @Nullable ItemStack blacklistedStack, @Nullable Fluid fluidWhitelist, PlayerEntity player, IFluidHandler.FluidAction action) {
        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
        Wrapper<FluidStack> drained = new Wrapper<FluidStack>(FluidStack.EMPTY);
        Wrapper<Integer> amountHolder = new Wrapper<Integer>(amount);
        while (it.hasNext() && amountHolder.get() > 0) {
            ItemStack current = it.next();
            if (current == null || current == blacklistedStack || FluidUtil.getFluidHandler((ItemStack)current) == null) continue;
            FluidUtil.getFluidHandler((ItemStack)current).ifPresent(fluidHandler -> {
                FluidStack thisDrained;
                FluidStack totalFluid = FluidHelpers.getFluid((IFluidHandler)fluidHandler);
                if (!(totalFluid.isEmpty() || fluidWhitelist != null && totalFluid.getFluid() != fluidWhitelist || (thisDrained = fluidHandler.drain(((Integer)amountHolder.get()).intValue(), action)).isEmpty() || fluidWhitelist != null && thisDrained.getFluid() != fluidWhitelist)) {
                    if (((FluidStack)drained.get()).isEmpty()) {
                        drained.set(thisDrained);
                    } else {
                        ((FluidStack)drained.get()).setAmount(((FluidStack)drained.get()).getAmount() + thisDrained.getAmount());
                    }
                    amountHolder.set((Integer)amountHolder.get() - thisDrained.getAmount());
                }
            });
        }
        if (drained.get() != null && drained.get().getAmount() == 0) {
            drained.set(FluidStack.EMPTY);
        }
        return drained.get();
    }

    public static FluidStack extractFromItemOrInventory(int amount, ItemStack itemStack, @Nullable PlayerEntity player, IFluidHandler.FluidAction action) {
        if (action.execute() && player != null && player.func_184812_l_() && !player.field_70170_p.func_201670_d()) {
            action = IFluidHandler.FluidAction.SIMULATE;
        }
        if (amount == 0) {
            return FluidStack.EMPTY;
        }
        IFluidHandler.FluidAction finalAction = action;
        return (FluidStack)FluidUtil.getFluidHandler((ItemStack)itemStack).map(fluidHandler -> {
            FluidStack otherDrained;
            FluidStack drained = fluidHandler.drain(amount, finalAction);
            if (!drained.isEmpty() && drained.getAmount() == amount) {
                return drained;
            }
            int drainedAmount = drained.isEmpty() ? 0 : drained.getAmount();
            int toDrain = amount - drainedAmount;
            FluidStack fluidStack = otherDrained = player == null ? null : FluidHelpers.extractFromInventory(toDrain, itemStack, FluidHelpers.getFluid((IFluidHandler)fluidHandler).getFluid(), player, finalAction);
            if (otherDrained == null) {
                return drained;
            }
            otherDrained.setAmount(otherDrained.getAmount() + drainedAmount);
            return otherDrained;
        }).orElse((Object)FluidStack.EMPTY);
    }

    public static void placeOrPickUpFluid(PlayerEntity player, Hand hand, World world, BlockPos blockPos, Direction side) {
        ItemStack itemStack = player.func_184586_b(hand);
        ItemStack itemStackResult = (ItemStack)FluidHelpers.getFluidHandlerItemCapacity(itemStack).map(fluidHandler -> {
            FluidActionResult resultPlace;
            FluidActionResult resultPickUp;
            FluidStack fluidStack = (FluidStack)FluidUtil.getFluidContained((ItemStack)itemStack).orElse((Object)FluidStack.EMPTY);
            FluidStack drained = fluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            if ((fluidStack.isEmpty() || fluidStack.getAmount() + 1000 <= fluidHandler.getCapacity()) && (resultPickUp = FluidUtil.tryPickUpFluid((ItemStack)itemStack, (PlayerEntity)player, (World)world, (BlockPos)blockPos, (Direction)side)).isSuccess()) {
                return resultPickUp.getResult();
            }
            if (!drained.isEmpty() && drained.getAmount() > 0 && (resultPlace = FluidUtil.tryPlaceFluid((PlayerEntity)player, (World)world, (Hand)hand, (BlockPos)blockPos, (ItemStack)itemStack, (FluidStack)fluidStack)).isSuccess()) {
                return resultPlace.getResult();
            }
            return itemStack;
        }).orElse((Object)itemStack);
        player.func_184611_a(hand, itemStackResult);
    }

    public static IFluidHandler.FluidAction simulateBooleanToAction(boolean simulate) {
        return simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
    }
}

