/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.world;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTProviderComponent;

public abstract class WorldStorage
implements INBTProvider {
    private static String KEY = "WorldStorageData";
    protected final ModBase mod;
    private INBTProvider nbtProviderComponent = new NBTProviderComponent(this);

    public WorldStorage(ModBase mod) {
        this.mod = mod;
    }

    public void readFromNBT(CompoundNBT tag) {
        this.readGeneratedFieldsFromNBT(tag);
    }

    public void writeToNBT(CompoundNBT tag) {
        this.writeGeneratedFieldsToNBT(tag);
    }

    public abstract void reset();

    public void onAboutToStartEvent(FMLServerAboutToStartEvent event) {
        this.reset();
    }

    public void onStartedEvent(FMLServerStartedEvent event) {
        this.reset();
        this.loadData(event.getServer());
        this.afterLoad();
    }

    public void onStoppingEvent(FMLServerStoppingEvent event) {
        this.beforeSave();
        this.saveData(event.getServer());
    }

    protected abstract String getDataId();

    private NBTDataHolder initDataHolder(MinecraftServer server, boolean loading) {
        CompoundNBT tempTag;
        String dataId = this.mod.getModId() + "_" + this.getDataId();
        NBTDataHolder data = (NBTDataHolder)server.func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215752_a(() -> new NBTDataHolder(dataId), dataId);
        if (loading && (tempTag = data.getTempTagAndReset()) != null) {
            this.readFromNBT(tempTag);
        }
        data.setParentStorage(this);
        return data;
    }

    private synchronized void loadData(MinecraftServer server) {
        this.initDataHolder(server, true);
    }

    private synchronized void saveData(MinecraftServer server) {
        this.initDataHolder(server, false);
    }

    public void afterLoad() {
    }

    public void beforeSave() {
    }

    @Override
    public void writeGeneratedFieldsToNBT(CompoundNBT tag) {
        this.nbtProviderComponent.writeGeneratedFieldsToNBT(tag);
    }

    @Override
    public void readGeneratedFieldsFromNBT(CompoundNBT tag) {
        this.nbtProviderComponent.readGeneratedFieldsFromNBT(tag);
    }

    public static class NBTDataHolder
    extends WorldSavedData {
        private WorldStorage parentStorage = null;
        private CompoundNBT tempTag = null;

        public NBTDataHolder(String key) {
            super(key);
        }

        public void func_76184_a(CompoundNBT tag) {
            if (this.parentStorage == null) {
                this.tempTag = tag.func_74775_l(KEY);
            } else {
                this.parentStorage.readFromNBT(tag.func_74775_l(KEY));
            }
        }

        public CompoundNBT func_189551_b(CompoundNBT tag) {
            CompoundNBT dataTag = new CompoundNBT();
            this.parentStorage.writeToNBT(dataTag);
            tag.func_218657_a(KEY, (INBT)dataTag);
            return tag;
        }

        public boolean func_76188_b() {
            return true;
        }

        public void setParentStorage(WorldStorage parentStorage) {
            this.parentStorage = parentStorage;
        }

        public CompoundNBT getTempTagAndReset() {
            CompoundNBT tempTag = this.tempTag;
            this.tempTag = null;
            return tempTag;
        }
    }
}

