/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Rectangle;
import java.util.ArrayList;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;

public abstract class ContainerScreenScrolling<T extends ScrollingInventoryContainer>
extends ContainerScreenExtended<T> {
    private static final int SEARCH_WIDTH = 89;
    private WidgetTextFieldExtended searchField = null;
    private WidgetScrollBar scrollbar = null;

    public ContainerScreenScrolling(T container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        if (this.isSearchEnabled()) {
            int searchWidth = this.getSearchWidth();
            int searchX = this.getSearchX();
            int searchY = this.getSearchY();
            if (this.searchField == null) {
                this.field_230712_o_.getClass();
                this.searchField = new WidgetTextFieldExtended(this.field_230712_o_, this.field_147003_i + searchX, this.field_147009_r + searchY, searchWidth, 9, (ITextComponent)new TranslationTextComponent("gui.cyclopscore.search"));
                this.searchField.func_146203_f(64);
                this.searchField.func_146203_f(15);
                this.searchField.func_146185_a(false);
                this.searchField.func_146189_e(true);
                this.searchField.func_146193_g(0xFFFFFF);
                this.searchField.func_146205_d(true);
                this.searchField.func_146180_a("");
                this.searchField.func_230991_b_(searchWidth);
                this.searchField.field_230690_l_ = this.field_147003_i + (searchX + searchWidth) - this.searchField.func_230998_h_();
            } else {
                this.searchField.func_230991_b_(searchWidth);
                this.searchField.field_230690_l_ = this.field_147003_i + (searchX + searchWidth) - this.searchField.func_230998_h_();
                this.searchField.field_230691_m_ = this.field_147009_r + searchY;
            }
            this.field_230705_e_.add(this.searchField);
        }
        if (this.scrollbar == null) {
            ((ScrollingInventoryContainer)this.func_212873_a_()).updateFilter("");
            this.scrollbar = new WidgetScrollBar(this.field_147003_i + this.getScrollX(), this.field_147009_r + this.getScrollY(), this.getScrollHeight(), (ITextComponent)new TranslationTextComponent("gui.cyclopscore.scrollbar"), (WidgetScrollBar.IScrollCallback)this.func_212873_a_(), ((ScrollingInventoryContainer)this.func_212873_a_()).getPageSize(), this.getScrollRegion());
            this.scrollbar.setTotalRows(((ScrollingInventoryContainer)this.func_212873_a_()).getFilteredItemCount() / ((ScrollingInventoryContainer)this.func_212873_a_()).getColumns());
        }
        this.field_230705_e_.add(this.scrollbar);
        this.getScrollbar().scrollTo(this.scrollbar.getCurrentScroll());
    }

    protected Rectangle getScrollRegion() {
        return null;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.searchField != null) {
            this.searchField.func_146178_a();
        }
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (this.isSearchEnabled()) {
            if (this.searchField.func_231042_a_(typedChar, keyCode)) {
                this.updateSearch(this.searchField.func_146179_b());
            }
            return true;
        }
        return super.func_231042_a_(typedChar, keyCode);
    }

    public boolean func_231046_a_(int typedChar, int keyCode, int modifiers) {
        if (this.isSearchEnabled() && typedChar != 256) {
            if (this.searchField.func_231046_a_(typedChar, keyCode, modifiers)) {
                this.updateSearch(this.searchField.func_146179_b());
            }
            return true;
        }
        return super.func_231046_a_(typedChar, keyCode, modifiers);
    }

    @Override
    protected void drawCurrentScreen(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isSubsetRenderSlots()) {
            ArrayList oldSlots = Lists.newArrayList((Iterable)((ScrollingInventoryContainer)this.field_147002_h).field_75151_b);
            int startIndex = ((ScrollingInventoryContainer)this.func_212873_a_()).getFirstElement();
            ArrayList newSlots = Lists.newArrayList();
            newSlots.addAll(oldSlots.subList(startIndex, Math.min(oldSlots.size(), startIndex + ((ScrollingInventoryContainer)this.func_212873_a_()).getPageSize() * ((ScrollingInventoryContainer)this.func_212873_a_()).getColumns())));
            newSlots.addAll(oldSlots.subList(((ScrollingInventoryContainer)this.func_212873_a_()).getUnfilteredItemCount(), oldSlots.size()));
            ((ScrollingInventoryContainer)this.field_147002_h).field_75151_b.clear();
            ((ScrollingInventoryContainer)this.field_147002_h).field_75151_b.addAll(newSlots);
            super.drawCurrentScreen(matrixStack, mouseX, mouseY, partialTicks);
            ((ScrollingInventoryContainer)this.field_147002_h).field_75151_b.clear();
            ((ScrollingInventoryContainer)this.field_147002_h).field_75151_b.addAll(oldSlots);
        } else {
            super.drawCurrentScreen(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    protected boolean isSubsetRenderSlots() {
        return false;
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        if (this.isSearchEnabled()) {
            this.searchField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        this.scrollbar.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        if (this.func_241217_q_() != null && this.func_231041_ay__() && mouseButton == 0 && this.func_241217_q_().func_231045_a_(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev)) {
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    protected void updateSearch(String searchString) {
        ((ScrollingInventoryContainer)this.func_212873_a_()).updateFilter(searchString);
        this.scrollbar.setTotalRows(((ScrollingInventoryContainer)this.func_212873_a_()).getFilteredItemCount() / ((ScrollingInventoryContainer)this.func_212873_a_()).getColumns());
        this.scrollbar.scrollTo(0.0f);
    }

    public TextFieldWidget getSearchField() {
        return this.searchField;
    }

    public WidgetScrollBar getScrollbar() {
        return this.scrollbar;
    }

    protected int getScrollX() {
        return 175;
    }

    protected int getScrollY() {
        return 18;
    }

    protected int getScrollHeight() {
        return 112;
    }

    protected boolean isSearchEnabled() {
        return true;
    }

    protected int getSearchX() {
        return 82;
    }

    protected int getSearchY() {
        return 6;
    }

    protected int getSearchWidth() {
        return 89;
    }
}

