/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.model;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.cyclops.cyclopscore.client.model.DynamicBaseModel;

public abstract class DynamicItemAndBlockModel
extends DynamicBaseModel {
    private final boolean factory;
    private final boolean item;
    private final ItemOverrides itemOverrides;
    private Direction renderingSide;

    public DynamicItemAndBlockModel(boolean factory, boolean item) {
        this.factory = factory;
        this.item = item;
        this.itemOverrides = new ItemOverrides();
    }

    protected boolean isItemStack() {
        return this.item;
    }

    @Override
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        IBakedModel bakedModel;
        this.renderingSide = side;
        if (this.factory && (bakedModel = this.isItemStack() ? this.handleItemState(null, null, null) : this.handleBlockState(state, side, rand, extraData)) != null) {
            return bakedModel.func_200117_a(state, side, rand);
        }
        return this.getGeneralQuads();
    }

    public List<BakedQuad> getGeneralQuads() {
        return Collections.emptyList();
    }

    public abstract IBakedModel handleBlockState(@Nullable BlockState var1, @Nullable Direction var2, @Nonnull Random var3, @Nonnull IModelData var4);

    public abstract IBakedModel handleItemState(@Nullable ItemStack var1, @Nullable World var2, @Nullable LivingEntity var3);

    @Override
    public ItemOverrideList func_188617_f() {
        return this.itemOverrides;
    }

    public Direction getRenderingSide() {
        return this.renderingSide;
    }

    public class ItemOverrides
    extends ItemOverrideList {
        @Nullable
        public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            return DynamicItemAndBlockModel.this.handleItemState(stack, (World)world, entity);
        }
    }
}

