/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.datastructure;

import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class DimPos
implements Comparable<DimPos> {
    private final String world;
    private final BlockPos blockPos;
    private WeakReference<World> worldReference;

    private DimPos(String dimension, BlockPos blockPos, World world) {
        this.world = dimension;
        this.blockPos = blockPos;
        this.worldReference = world != null && world.func_201670_d() ? new WeakReference<World>(world) : null;
    }

    private DimPos(String world, BlockPos blockPos) {
        this(world, blockPos, null);
    }

    public RegistryKey<World> getWorldKey() {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(this.getWorld()));
    }

    @Nullable
    public World getWorld(boolean forceLoad) {
        if (this.worldReference == null) {
            if (MinecraftHelpers.isClientSideThread()) {
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                if (world.func_234923_W_().func_240901_a_().toString().equals(this.getWorld())) {
                    this.worldReference = new WeakReference<ClientWorld>(world);
                    return (World)this.worldReference.get();
                }
                return null;
            }
            return ServerLifecycleHooks.getCurrentServer().func_71218_a(this.getWorldKey());
        }
        World world = (World)this.worldReference.get();
        if (world == null) {
            world = ServerLifecycleHooks.getCurrentServer().func_71218_a(this.getWorldKey());
            this.worldReference = new WeakReference<World>(world);
        }
        return world;
    }

    public boolean isLoaded() {
        World world = this.getWorld(false);
        return world != null && world.func_175667_e(this.getBlockPos());
    }

    @Override
    public int compareTo(DimPos o) {
        int compareDim = this.getWorld().compareTo(o.getWorld());
        if (compareDim == 0) {
            return MinecraftHelpers.compareBlockPos(this.getBlockPos(), o.getBlockPos());
        }
        return compareDim;
    }

    public boolean equals(Object o) {
        return o instanceof DimPos && this.compareTo((DimPos)o) == 0;
    }

    public int hashCode() {
        return 31 * this.getWorld().hashCode() + this.getBlockPos().hashCode();
    }

    public static DimPos of(World world, BlockPos blockPos) {
        return DimPos.of((RegistryKey<World>)world.func_234923_W_(), blockPos);
    }

    public static DimPos of(RegistryKey<World> world, BlockPos blockPos) {
        return new DimPos(world.func_240901_a_().toString(), blockPos);
    }

    public String getWorld() {
        return this.world;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public WeakReference<World> getWorldReference() {
        return this.worldReference;
    }

    public void setWorldReference(WeakReference<World> worldReference) {
        this.worldReference = worldReference;
    }

    public String toString() {
        return "DimPos(world=" + this.getWorld() + ", blockPos=" + this.getBlockPos() + ", worldReference=" + this.getWorldReference() + ")";
    }
}

