/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.datastructure.DimPos;

public final class TileHelpers {
    public static boolean UNSAFE_TILE_ENTITY_GETTER = false;

    public static <T> Optional<T> getSafeTile(DimPos dimPos, Class<T> targetClazz) {
        World world = dimPos.getWorld(true);
        if (world == null) {
            return Optional.empty();
        }
        return TileHelpers.getSafeTile((IBlockReader)world, dimPos.getBlockPos(), targetClazz);
    }

    public static <T> Optional<T> getSafeTile(IBlockReader world, BlockPos pos, Class<T> targetClazz) {
        TileEntity tile;
        TileEntity tileEntity = tile = UNSAFE_TILE_ENTITY_GETTER && world instanceof World && !((World)world).func_201670_d() ? TileHelpers.getWorldTileEntityUnchecked((World)world, pos) : world.func_175625_s(pos);
        if (tile == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(targetClazz.cast(tile));
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    @Nullable
    static TileEntity getWorldTileEntityUnchecked(World world, BlockPos pos) {
        if (World.func_189509_E((BlockPos)pos)) {
            return null;
        }
        TileEntity tileentity = null;
        if (world.field_147481_N) {
            tileentity = world.func_189508_F(pos);
        }
        if (tileentity == null) {
            tileentity = world.func_175726_f(pos).func_177424_a(pos, Chunk.CreateEntityType.IMMEDIATE);
        }
        if (tileentity == null) {
            tileentity = world.func_189508_F(pos);
        }
        return tileentity;
    }

    public static <C> LazyOptional<C> getCapability(DimPos dimPos, Capability<C> capability) {
        World world = dimPos.getWorld(true);
        if (world == null) {
            return LazyOptional.empty();
        }
        return TileHelpers.getCapability((IBlockReader)world, dimPos.getBlockPos(), null, capability);
    }

    public static <C> LazyOptional<C> getCapability(DimPos dimPos, Direction side, Capability<C> capability) {
        World world = dimPos.getWorld(true);
        if (world == null) {
            return LazyOptional.empty();
        }
        return TileHelpers.getCapability((IBlockReader)world, dimPos.getBlockPos(), side, capability);
    }

    public static <C> LazyOptional<C> getCapability(IBlockReader world, BlockPos pos, Capability<C> capability) {
        return TileHelpers.getCapability(world, pos, null, capability);
    }

    public static <C> LazyOptional<C> getCapability(IBlockReader world, BlockPos pos, Direction side, Capability<C> capability) {
        TileEntity tile = TileHelpers.getSafeTile(world, pos, TileEntity.class).orElse(null);
        if (tile != null) {
            return tile.getCapability(capability, side);
        }
        return LazyOptional.empty();
    }
}

