/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.nbt.path.parse;

import java.util.stream.Stream;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import org.cyclops.cyclopscore.nbt.path.INbtPathExpression;
import org.cyclops.cyclopscore.nbt.path.NbtPathExpressionMatches;
import org.cyclops.cyclopscore.nbt.path.parse.INbtPathExpressionParseHandler;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionExecutionContext;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathStringParser;

public class NbtPathExpressionParseHandlerStringEqual
implements INbtPathExpressionParseHandler {
    private static int skipSpaces(String string, int pos) {
        while (pos < string.length() && string.charAt(pos) == ' ') {
            ++pos;
        }
        return pos;
    }

    @Override
    public INbtPathExpressionParseHandler.HandleResult handlePrefixOf(String nbtPathExpression, int pos) {
        int currentPos = NbtPathExpressionParseHandlerStringEqual.skipSpaces(nbtPathExpression, pos);
        if (currentPos + 1 >= nbtPathExpression.length()) {
            return INbtPathExpressionParseHandler.HandleResult.INVALID;
        }
        if (nbtPathExpression.charAt(currentPos) != '=' || nbtPathExpression.charAt(currentPos + 1) != '=') {
            return INbtPathExpressionParseHandler.HandleResult.INVALID;
        }
        NbtPathStringParser.StringParseResult parseResult = NbtPathStringParser.parse(nbtPathExpression, currentPos = NbtPathExpressionParseHandlerStringEqual.skipSpaces(nbtPathExpression, currentPos + 2));
        if (!parseResult.isSuccess()) {
            return INbtPathExpressionParseHandler.HandleResult.INVALID;
        }
        return new INbtPathExpressionParseHandler.HandleResult(new Expression(parseResult.getResult()), currentPos - pos + parseResult.getConsumed());
    }

    public static class Expression
    implements INbtPathExpression {
        private final String targetString;

        public Expression(String targetString) {
            this.targetString = targetString;
        }

        String getTargetString() {
            return this.targetString;
        }

        @Override
        public NbtPathExpressionMatches matchContexts(Stream<NbtPathExpressionExecutionContext> executionContexts) {
            return new NbtPathExpressionMatches(executionContexts.map(executionContext -> {
                INBT nbt = executionContext.getCurrentTag();
                if (nbt.func_74732_a() == 8) {
                    StringNBT tag = (StringNBT)nbt;
                    return new NbtPathExpressionExecutionContext((INBT)ByteNBT.func_229671_a_((byte)(this.getTargetString().equals(tag.func_150285_a_()) ? (byte)1 : (byte)0)), (NbtPathExpressionExecutionContext)executionContext);
                }
                return new NbtPathExpressionExecutionContext((INBT)ByteNBT.func_229671_a_((byte)0), (NbtPathExpressionExecutionContext)executionContext);
            }));
        }
    }
}

