/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.nbt;

import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;

public class NBTProviderComponent
implements INBTProvider {
    private final INBTProvider provider;
    private List<Field> nbtPersistedFields = null;

    public NBTProviderComponent(INBTProvider provider) {
        this.provider = provider;
        this.generateNBTPersistedFields();
    }

    private void generateNBTPersistedFields() {
        this.nbtPersistedFields = new LinkedList<Field>();
        for (Class<?> clazz = this.provider.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(NBTPersist.class)) continue;
                this.nbtPersistedFields.add(field);
            }
        }
    }

    private void writePersistedField(Field field, CompoundNBT tag) {
        NBTClassType.performActionForField(this.provider, field, tag, true);
    }

    private void readPersistedField(Field field, CompoundNBT tag) {
        NBTClassType.performActionForField(this.provider, field, tag, false);
    }

    @Override
    public void writeGeneratedFieldsToNBT(CompoundNBT tag) {
        for (Field field : this.nbtPersistedFields) {
            this.writePersistedField(field, tag);
        }
    }

    @Override
    public void readGeneratedFieldsFromNBT(CompoundNBT tag) {
        for (Field field : this.nbtPersistedFields) {
            this.readPersistedField(field, tag);
        }
    }
}

