/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore;

import java.util.UUID;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.extendedconfig.DummyConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.tracking.Analytics;
import org.cyclops.cyclopscore.tracking.Versions;

public class GeneralConfig
extends DummyConfig {
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Config version for Cyclops Core.\nDO NOT EDIT MANUALLY!")
    public static String version = "0.4.2";
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Set 'true' to enable development debug mode. This will result in a lower performance!", requiresMcRestart=true)
    public static boolean debug = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the recipe loader should crash when finding invalid recipes.", requiresMcRestart=true)
    public static boolean crashOnInvalidRecipe = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If mod compatibility loader should crash hard if errors occur in that process.", requiresMcRestart=true)
    public static boolean crashOnModCompatCrash = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If an anonymous mod startup analytics request may be sent to our analytics service.")
    public static boolean analytics = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="The anonymous id used by the analytics service.")
    public static String anonymousAnalyticsID = UUID.randomUUID().toString();
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the version checker should be enabled.")
    public static boolean versionChecker = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="The minimum array size of potion types, increase to allow for more potion types.", requiresMcRestart=true)
    public static int minimumPotionTypesArraySize = 256;
    public static ConfigurableType TYPE = ConfigurableType.DUMMY;

    public GeneralConfig() {
        super(CyclopsCore._instance, true, "general", null, GeneralConfig.class);
    }

    @Override
    public void onRegistered() {
        if (!version.equals("0.4.2")) {
            this.getMod().log(Level.WARN, "The config file of Cyclops Core is out of date and might cause problems, please remove it so it can be regenerated.");
        }
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_INVALID_RECIPE, crashOnInvalidRecipe);
        this.getMod().putGenericReference(ModBase.REFKEY_DEBUGCONFIG, debug);
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_MODCOMPAT_CRASH, crashOnModCompatCrash);
        if (analytics) {
            Analytics.registerMod(this.getMod(), "UA-65307010-1");
        }
        if (versionChecker) {
            Versions.registerMod(this.getMod(), CyclopsCore._instance, "https://raw.githubusercontent.com/CyclopsMC/Versions/master/1.8/CyclopsCore.txt");
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

