/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import java.util.List;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.block.multi.AllowedBlock;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;

public class HollowCubeDetector
extends CubeDetector {
    public HollowCubeDetector(AllowedBlock[] allowedBlocks, List<? extends CubeDetector.IDetectionListener> listeners) {
        super(allowedBlocks, listeners);
    }

    @Override
    protected void postValidate(World world, final Vec3i size, final int[][] dimensionEgdes, final boolean valid, final BlockPos originCorner, final BlockPos excludeLocation) {
        this.coordinateRecursion(world, dimensionEgdes, new CubeDetector.BlockPosAction(){

            @Override
            public boolean run(World world, BlockPos location) {
                if (HollowCubeDetector.this.isEdge(world, dimensionEgdes, location) && HollowCubeDetector.this.isValidLocation(world, location, excludeLocation) == null) {
                    HollowCubeDetector.this.notifyListeners(world, location, size, valid, originCorner);
                }
                return true;
            }
        });
    }

    @Override
    protected L10NHelpers.UnlocalizedString validateLocationInStructure(World world, int[][] dimensionEgdes, BlockPos location, CubeDetector.IValidationAction action, BlockPos excludeLocation) {
        if (this.isEdge(world, dimensionEgdes, location)) {
            L10NHelpers.UnlocalizedString error = this.isValidLocation(world, location, action, excludeLocation);
            if (error != null) {
                return error;
            }
        } else if (!this.isAir(world, location)) {
            return new L10NHelpers.UnlocalizedString("multiblock.cyclopscore.error.hollow.air", LocationHelpers.toCompactString(location));
        }
        return null;
    }
}

