/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.property;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.block.property.IBlockPropertyManager;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class BlockPropertyManagerComponent
implements IBlockPropertyManager {
    private static final Comparator<IProperty> DEFAULT_PROPERTY_COMPARATOR = new PropertyComparator();
    private static final Comparator<IUnlistedProperty> DEFAULT_UNLISTEDPROPERTY_COMPARATOR = new UnlistedPropertyComparator();
    private final Block block;
    private final IProperty[] properties;
    private final IUnlistedProperty[] unlistedProperties;
    private final IProperty[] propertiesReversed;
    private final Map<IProperty, ArrayList<Comparable>> propertyValues;
    private final Comparator<IProperty> propertyComparator;
    private final Comparator<IUnlistedProperty> unlistedPropertyComparator;

    public BlockPropertyManagerComponent(Block block, Comparator<IProperty> propertyComparator, Comparator<IUnlistedProperty> unlistedPropertyComparator) {
        this.block = block;
        this.propertyComparator = propertyComparator;
        this.unlistedPropertyComparator = unlistedPropertyComparator;
        try {
            Pair<IProperty[], IUnlistedProperty[]> allProperties = this.preprocessProperties();
            this.properties = (IProperty[])allProperties.getLeft();
            this.unlistedProperties = (IUnlistedProperty[])allProperties.getRight();
            this.propertiesReversed = Arrays.copyOf(this.properties, this.properties.length);
            ArrayUtils.reverse((Object[])this.propertiesReversed);
            this.propertyValues = this.preprocessPropertyValues(this.properties);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public BlockPropertyManagerComponent(Block block) {
        this(block, DEFAULT_PROPERTY_COMPARATOR, DEFAULT_UNLISTEDPROPERTY_COMPARATOR);
    }

    private Comparator<IProperty> getPropertyComponent() {
        return this.propertyComparator;
    }

    private Comparator<IUnlistedProperty> getUnlistedPropertyComponent() {
        return this.unlistedPropertyComparator;
    }

    private Pair<IProperty[], IUnlistedProperty[]> preprocessProperties() throws IllegalAccessException {
        TreeSet sortedProperties = Sets.newTreeSet(this.getPropertyComparator());
        TreeSet sortedUnlistedProperties = Sets.newTreeSet(this.getUnlistedPropertyComparator());
        TreeSet ignoredProperties = Sets.newTreeSet(this.getPropertyComparator());
        for (Class<?> clazz = this.block.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(BlockProperty.class)) continue;
                BlockProperty annotation = field.getAnnotation(BlockProperty.class);
                boolean ignored = annotation.ignore();
                Object fieldObject = field.get(this.block);
                if (fieldObject instanceof IProperty) {
                    sortedProperties.add((IProperty)fieldObject);
                    if (!ignored) continue;
                    ignoredProperties.add((IProperty)fieldObject);
                    continue;
                }
                if (fieldObject instanceof IUnlistedProperty) {
                    sortedUnlistedProperties.add((IUnlistedProperty)fieldObject);
                    continue;
                }
                if (fieldObject instanceof IProperty[]) {
                    for (IProperty property : (IProperty[])fieldObject) {
                        sortedProperties.add(property);
                        if (!ignored) continue;
                        ignoredProperties.add(property);
                    }
                    continue;
                }
                if (fieldObject instanceof IUnlistedProperty[]) {
                    Collections.addAll(sortedUnlistedProperties, (IUnlistedProperty[])fieldObject);
                    continue;
                }
                throw new IllegalArgumentException(String.format("The field %s in class %s can not be used as block property.", field.getName(), clazz.getCanonicalName()));
            }
        }
        if (MinecraftHelpers.isClientSide() && ignoredProperties.size() != 0) {
            this.ignoreProperties(ignoredProperties);
        }
        IProperty[] properties = new IProperty[sortedProperties.size()];
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[sortedUnlistedProperties.size()];
        return Pair.of((Object)sortedProperties.toArray(properties), (Object)sortedUnlistedProperties.toArray(unlistedProperties));
    }

    @SideOnly(value=Side.CLIENT)
    protected void ignoreProperties(TreeSet<IProperty> ignoredProperties) {
        IProperty[] ignoredPropertiesArray = new IProperty[ignoredProperties.size()];
        ignoredProperties.toArray(ignoredPropertiesArray);
        ModelLoader.setCustomStateMapper((Block)this.block, (IStateMapper)new StateMap.Builder().func_178442_a(ignoredPropertiesArray).func_178441_a());
    }

    private Map<IProperty, ArrayList<Comparable>> preprocessPropertyValues(IProperty[] properties) {
        HashMap dict = Maps.newHashMap();
        for (IProperty property : properties) {
            ArrayList values = Lists.newArrayList((Iterable)property.func_177700_c());
            Collections.sort(values);
            dict.put(property, values);
        }
        return dict;
    }

    @Override
    public int getMetaFromState(IBlockState blockState) {
        int meta = 0;
        for (IProperty property : this.properties) {
            int propertySize = property.func_177700_c().size();
            int propertyValueIndex = this.propertyValues.get(property).indexOf(blockState.func_177229_b(property));
            if (propertyValueIndex < 0) {
                throw new RuntimeException(String.format("The value %s was not found in the calculated property values for %s.", propertyValueIndex, property));
            }
            meta = meta * propertySize + propertyValueIndex;
        }
        if (meta > 65535) {
            throw new RuntimeException(String.format("The metadata for %s was too large (%s) to store.", this, meta));
        }
        return meta;
    }

    @Override
    public IBlockState getStateFromMeta(int meta) {
        IBlockState blockState = this.block.func_176223_P();
        int metaLoop = meta;
        for (IProperty property : this.propertiesReversed) {
            int propertySize = property.func_177700_c().size();
            int value = metaLoop % propertySize;
            Comparable propertyValue = this.propertyValues.get(property).get(value);
            if (propertyValue == null) {
                throw new RuntimeException(String.format("The value %s was not found in the calculated property values for %s.", value, property));
            }
            blockState = blockState.func_177226_a(property, propertyValue);
            metaLoop = (metaLoop - value) / propertySize;
        }
        return blockState;
    }

    @Override
    public BlockState createDelegatedBlockState() {
        if (this.unlistedProperties.length == 0) {
            return new BlockState(this.block, this.properties);
        }
        return new ExtendedBlockState(this.block, this.properties, this.unlistedProperties);
    }

    public Block getBlock() {
        return this.block;
    }

    public IProperty[] getProperties() {
        return this.properties;
    }

    public IUnlistedProperty[] getUnlistedProperties() {
        return this.unlistedProperties;
    }

    public IProperty[] getPropertiesReversed() {
        return this.propertiesReversed;
    }

    public Map<IProperty, ArrayList<Comparable>> getPropertyValues() {
        return this.propertyValues;
    }

    public Comparator<IProperty> getPropertyComparator() {
        return this.propertyComparator;
    }

    public Comparator<IUnlistedProperty> getUnlistedPropertyComparator() {
        return this.unlistedPropertyComparator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockPropertyManagerComponent)) {
            return false;
        }
        BlockPropertyManagerComponent other = (BlockPropertyManagerComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Block this$block = this.getBlock();
        Block other$block = other.getBlock();
        if (this$block == null ? other$block != null : !this$block.equals(other$block)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getProperties(), other.getProperties())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getUnlistedProperties(), other.getUnlistedProperties())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPropertiesReversed(), other.getPropertiesReversed())) {
            return false;
        }
        Map<IProperty, ArrayList<Comparable>> this$propertyValues = this.getPropertyValues();
        Map<IProperty, ArrayList<Comparable>> other$propertyValues = other.getPropertyValues();
        if (this$propertyValues == null ? other$propertyValues != null : !((Object)this$propertyValues).equals(other$propertyValues)) {
            return false;
        }
        Comparator<IProperty> this$propertyComparator = this.getPropertyComparator();
        Comparator<IProperty> other$propertyComparator = other.getPropertyComparator();
        if (this$propertyComparator == null ? other$propertyComparator != null : !((Object)this$propertyComparator).equals(other$propertyComparator)) {
            return false;
        }
        Comparator<IUnlistedProperty> this$unlistedPropertyComparator = this.getUnlistedPropertyComparator();
        Comparator<IUnlistedProperty> other$unlistedPropertyComparator = other.getUnlistedPropertyComparator();
        return !(this$unlistedPropertyComparator == null ? other$unlistedPropertyComparator != null : !((Object)this$unlistedPropertyComparator).equals(other$unlistedPropertyComparator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockPropertyManagerComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Block $block = this.getBlock();
        result = result * 59 + ($block == null ? 0 : $block.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getProperties());
        result = result * 59 + Arrays.deepHashCode(this.getUnlistedProperties());
        result = result * 59 + Arrays.deepHashCode(this.getPropertiesReversed());
        Map<IProperty, ArrayList<Comparable>> $propertyValues = this.getPropertyValues();
        result = result * 59 + ($propertyValues == null ? 0 : ((Object)$propertyValues).hashCode());
        Comparator<IProperty> $propertyComparator = this.getPropertyComparator();
        result = result * 59 + ($propertyComparator == null ? 0 : $propertyComparator.hashCode());
        Comparator<IUnlistedProperty> $unlistedPropertyComparator = this.getUnlistedPropertyComparator();
        result = result * 59 + ($unlistedPropertyComparator == null ? 0 : $unlistedPropertyComparator.hashCode());
        return result;
    }

    public String toString() {
        return "BlockPropertyManagerComponent(block=" + this.getBlock() + ", properties=" + Arrays.deepToString(this.getProperties()) + ", unlistedProperties=" + Arrays.deepToString(this.getUnlistedProperties()) + ", propertiesReversed=" + Arrays.deepToString(this.getPropertiesReversed()) + ", propertyValues=" + this.getPropertyValues() + ", propertyComparator=" + this.getPropertyComparator() + ", unlistedPropertyComparator=" + this.getUnlistedPropertyComparator() + ")";
    }

    public static class UnlistedPropertyComparator
    implements Comparator<IUnlistedProperty> {
        @Override
        public int compare(IUnlistedProperty o1, IUnlistedProperty o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class PropertyComparator
    implements Comparator<IProperty> {
        @Override
        public int compare(IProperty o1, IProperty o2) {
            return o1.func_177701_a().compareTo(o2.func_177701_a());
        }
    }
}

