/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.input;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.input.GuiTextFieldExtended;

public class GuiNumberField
extends GuiTextFieldExtended {
    private final boolean arrows;
    private GuiButtonArrow arrowUp;
    private GuiButtonArrow arrowDown;
    private boolean positiveOnly = true;

    public GuiNumberField(int componentId, FontRenderer fontrenderer, int x, int y, int width, int height, boolean arrows, boolean background) {
        super(componentId, fontrenderer, x, y, width, height, background);
        this.arrows = arrows;
        if (this.arrows) {
            this.arrowUp = new GuiButtonArrow(0, x, y + height / 2, GuiButtonArrow.Direction.NORTH);
            this.arrowDown = new GuiButtonArrow(1, x, y + height / 2, GuiButtonArrow.Direction.SOUTH);
            this.arrowUp.field_146129_i -= this.arrowUp.field_146121_g;
        }
        this.func_146185_a(true);
        this.func_146180_a("0");
    }

    public boolean func_146181_i() {
        return false;
    }

    public void setPositiveOnly(boolean positiveOnly) {
        this.positiveOnly = positiveOnly;
    }

    public int getInt() throws NumberFormatException {
        return Integer.parseInt(this.func_146179_b());
    }

    public double getDouble() throws NumberFormatException {
        return Double.parseDouble(this.func_146179_b());
    }

    public float getFloat() throws NumberFormatException {
        return Float.parseFloat(this.func_146179_b());
    }

    @Override
    public void drawTextBox(Minecraft minecraft, int mouseX, int mouseY) {
        int offsetX = 0;
        if (this.arrows) {
            this.arrowUp.func_146112_a(minecraft, mouseX, mouseY);
            this.arrowDown.func_146112_a(minecraft, mouseX, mouseY);
            offsetX = this.arrowUp.field_146120_f;
            this.field_146209_f += offsetX;
            this.field_146218_h -= offsetX;
        }
        super.drawTextBox(minecraft, mouseX, mouseY);
        if (this.arrows) {
            this.field_146209_f -= offsetX;
            this.field_146218_h += offsetX;
        }
    }

    protected int validateNumber(int number) {
        if (this.positiveOnly) {
            return Math.max(number, 0);
        }
        return number;
    }

    protected int getDiffAmount() {
        return Minecraft.func_71410_x().field_71439_g.func_70093_af() ? 10 : 1;
    }

    protected void increase() {
        try {
            this.func_146180_a(Integer.toString(this.validateNumber(this.getInt() + this.getDiffAmount())));
        }
        catch (NumberFormatException e) {
            this.func_146180_a("0");
        }
    }

    protected void decrease() {
        try {
            this.func_146180_a(Integer.toString(this.validateNumber(this.getInt() - this.getDiffAmount())));
        }
        catch (NumberFormatException e) {
            this.func_146180_a("0");
        }
    }

    public void func_146192_a(int mouseX, int mouseY, int mouseButton) {
        if (this.arrowUp.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY)) {
            this.increase();
        } else if (this.arrowDown.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY)) {
            this.decrease();
        } else {
            super.func_146192_a(mouseX, mouseY, mouseButton);
        }
        this.arrowDown.field_146124_l = true;
        try {
            if (this.getInt() == 0) {
                this.arrowDown.field_146124_l = false;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }
}

