/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.image;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.helper.Helpers;

public class Image
implements IImage {
    private final ResourceLocation resourceLocation;
    private final int sheetX;
    private final int sheetY;
    private final int sheetWidth;
    private final int sheetHeight;

    public Image(ResourceLocation resourceLocation, int sheetX, int sheetY, int sheetWidth, int sheetHeight) {
        this.resourceLocation = resourceLocation;
        this.sheetX = sheetX;
        this.sheetY = sheetY;
        this.sheetWidth = sheetWidth;
        this.sheetHeight = sheetHeight;
    }

    @Override
    public void draw(Gui gui, int x, int y) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.resourceLocation);
        gui.func_73729_b(x, y, this.sheetX, this.sheetY, this.sheetWidth, this.sheetHeight);
    }

    @Override
    public void drawWorld(TextureManager textureManager, float x1, float x2, float y1, float y2, float z) {
        GlStateManager.func_179094_E();
        WorldRenderer worldRenderer = Tessellator.func_178181_a().func_178180_c();
        worldRenderer.func_178970_b();
        textureManager.func_110577_a(this.getResourceLocation());
        worldRenderer.func_178974_a(Helpers.RGBToInt(255, 255, 255), 255);
        float u1 = (float)this.getSheetX() / 256.0f;
        float u2 = (float)(this.getSheetX() + this.getSheetWidth()) / 256.0f;
        float v1 = (float)this.getSheetY() / 256.0f;
        float v2 = (float)(this.getSheetY() + this.getSheetHeight()) / 256.0f;
        worldRenderer.func_178985_a((double)x2, (double)y2, (double)z, (double)u2, (double)v2);
        worldRenderer.func_178985_a((double)x2, (double)y1, (double)z, (double)u2, (double)v1);
        worldRenderer.func_178985_a((double)x1, (double)y1, (double)z, (double)u1, (double)v1);
        worldRenderer.func_178985_a((double)x1, (double)y2, (double)z, (double)u1, (double)v2);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179121_F();
    }

    @Override
    public void drawWorld(TextureManager textureManager, float x1, float x2, float y1, float y2) {
        this.drawWorld(textureManager, x1, x2, y1, y2, 0.0f);
    }

    @Override
    public void drawWorld(TextureManager textureManager, float x2, float y2) {
        this.drawWorld(textureManager, 0.0f, x2, 0.0f, y2);
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public int getSheetX() {
        return this.sheetX;
    }

    public int getSheetY() {
        return this.sheetY;
    }

    public int getSheetWidth() {
        return this.sheetWidth;
    }

    public int getSheetHeight() {
        return this.sheetHeight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Image)) {
            return false;
        }
        Image other = (Image)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResourceLocation this$resourceLocation = this.getResourceLocation();
        ResourceLocation other$resourceLocation = other.getResourceLocation();
        if (this$resourceLocation == null ? other$resourceLocation != null : !this$resourceLocation.equals(other$resourceLocation)) {
            return false;
        }
        if (this.getSheetX() != other.getSheetX()) {
            return false;
        }
        if (this.getSheetY() != other.getSheetY()) {
            return false;
        }
        if (this.getSheetWidth() != other.getSheetWidth()) {
            return false;
        }
        return this.getSheetHeight() == other.getSheetHeight();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Image;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResourceLocation $resourceLocation = this.getResourceLocation();
        result = result * 59 + ($resourceLocation == null ? 0 : $resourceLocation.hashCode());
        result = result * 59 + this.getSheetX();
        result = result * 59 + this.getSheetY();
        result = result * 59 + this.getSheetWidth();
        result = result * 59 + this.getSheetHeight();
        return result;
    }

    public String toString() {
        return "Image(resourceLocation=" + this.getResourceLocation() + ", sheetX=" + this.getSheetX() + ", sheetY=" + this.getSheetY() + ", sheetWidth=" + this.getSheetWidth() + ", sheetHeight=" + this.getSheetHeight() + ")";
    }
}

