/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.model;

import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IFlexibleBakedModel;

public abstract class DynamicBaseModel
implements IFlexibleBakedModel {
    protected static final float[][] ROTATION_UV = new float[][]{{1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}};
    protected static final int[] ROTATION_FIX = new int[]{2, 0, 2, 0, 1, 3};
    protected static final float[][] UVS = new float[][]{{0.0f, 0.0f}, {1.0f, 1.0f}};

    protected static Vec3 rotate(Vec3 vec, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3(vec.field_72450_a, -vec.field_72448_b, -vec.field_72449_c);
            }
            case UP: {
                return new Vec3(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
            case NORTH: {
                return new Vec3(vec.field_72450_a, vec.field_72449_c, -vec.field_72448_b);
            }
            case SOUTH: {
                return new Vec3(vec.field_72450_a, -vec.field_72449_c, vec.field_72448_b);
            }
            case WEST: {
                return new Vec3(-vec.field_72448_b, vec.field_72450_a, vec.field_72449_c);
            }
            case EAST: {
                return new Vec3(vec.field_72448_b, -vec.field_72450_a, vec.field_72449_c);
            }
        }
        return vec;
    }

    protected static Vec3 revRotate(Vec3 vec, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3(vec.field_72450_a, -vec.field_72448_b, -vec.field_72449_c);
            }
            case UP: {
                return new Vec3(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
            case NORTH: {
                return new Vec3(vec.field_72450_a, -vec.field_72449_c, vec.field_72448_b);
            }
            case SOUTH: {
                return new Vec3(vec.field_72450_a, vec.field_72449_c, -vec.field_72448_b);
            }
            case WEST: {
                return new Vec3(vec.field_72448_b, -vec.field_72450_a, vec.field_72449_c);
            }
            case EAST: {
                return new Vec3(-vec.field_72448_b, vec.field_72450_a, vec.field_72449_c);
            }
        }
        return vec;
    }

    protected static int[] vertexToInts(float x, float y, float z, int color, TextureAtlasSprite texture, float u, float v) {
        return new int[]{Float.floatToRawIntBits(x), Float.floatToRawIntBits(y), Float.floatToRawIntBits(z), color, Float.floatToRawIntBits(texture.func_94214_a((double)u)), Float.floatToRawIntBits(texture.func_94207_b((double)v)), 0};
    }

    protected static void addBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, EnumFacing side) {
        Vec3 v1 = DynamicBaseModel.rotate(new Vec3((double)x1 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3 v2 = DynamicBaseModel.rotate(new Vec3((double)x1 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3 v3 = DynamicBaseModel.rotate(new Vec3((double)x2 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3 v4 = DynamicBaseModel.rotate(new Vec3((double)x2 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        int[] data = Ints.concat((int[][])new int[][]{DynamicBaseModel.vertexToInts((float)v1.field_72450_a, (float)v1.field_72448_b, (float)v1.field_72449_c, -1, texture, x1 * 16.0f, z1 * 16.0f), DynamicBaseModel.vertexToInts((float)v2.field_72450_a, (float)v2.field_72448_b, (float)v2.field_72449_c, -1, texture, x1 * 16.0f, z2 * 16.0f), DynamicBaseModel.vertexToInts((float)v3.field_72450_a, (float)v3.field_72448_b, (float)v3.field_72449_c, -1, texture, x2 * 16.0f, z2 * 16.0f), DynamicBaseModel.vertexToInts((float)v4.field_72450_a, (float)v4.field_72448_b, (float)v4.field_72449_c, -1, texture, x2 * 16.0f, z1 * 16.0f)});
        quads.add(new BakedQuad(data, -1, side));
    }

    protected static void addBakedQuadRotated(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, EnumFacing side, int rotation) {
        float[][] r = ROTATION_UV;
        Vec3 v1 = DynamicBaseModel.rotate(new Vec3((double)x1 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3 v2 = DynamicBaseModel.rotate(new Vec3((double)x1 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3 v3 = DynamicBaseModel.rotate(new Vec3((double)x2 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3 v4 = DynamicBaseModel.rotate(new Vec3((double)x2 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        int[] data = Ints.concat((int[][])new int[][]{DynamicBaseModel.vertexToInts((float)v1.field_72450_a, (float)v1.field_72448_b, (float)v1.field_72449_c, -1, texture, r[(0 + rotation) % 4][0] * 16.0f, r[(0 + rotation) % 4][1] * 16.0f), DynamicBaseModel.vertexToInts((float)v2.field_72450_a, (float)v2.field_72448_b, (float)v2.field_72449_c, -1, texture, r[(1 + rotation) % 4][0] * 16.0f, r[(1 + rotation) % 4][1] * 16.0f), DynamicBaseModel.vertexToInts((float)v3.field_72450_a, (float)v3.field_72448_b, (float)v3.field_72449_c, -1, texture, r[(2 + rotation) % 4][0] * 16.0f, r[(2 + rotation) % 4][1] * 16.0f), DynamicBaseModel.vertexToInts((float)v4.field_72450_a, (float)v4.field_72448_b, (float)v4.field_72449_c, -1, texture, r[(3 + rotation) % 4][0] * 16.0f, r[(3 + rotation) % 4][1] * 16.0f)});
        quads.add(new BakedQuad(data, -1, side));
    }

    public List<BakedQuad> func_177551_a(EnumFacing side) {
        return Collections.emptyList();
    }

    public List<BakedQuad> func_177550_a() {
        return null;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177553_d() {
        return false;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public VertexFormat getFormat() {
        return Attributes.DEFAULT_BAKED_FORMAT;
    }
}

