/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurable;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.IConfigurable;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.cyclopscore.item.DamageIndicatedItemFluidContainer;

public abstract class ConfigurableDamageIndicatedItemFluidContainer
extends DamageIndicatedItemFluidContainer
implements IConfigurable {
    protected ExtendedConfig eConfig = null;
    protected boolean canPickUp = true;
    private boolean placeFluids = false;

    protected ConfigurableDamageIndicatedItemFluidContainer(ExtendedConfig eConfig, int capacity, Fluid fluid) {
        super(capacity, fluid);
        this.setConfig(eConfig);
        this.func_77655_b(eConfig.getUnlocalizedName());
    }

    private void setConfig(ExtendedConfig eConfig) {
        this.eConfig = eConfig;
    }

    @Override
    public ExtendedConfig<?> getConfig() {
        return this.eConfig;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        FluidStack fluidStack = this.getFluid(itemStack);
        FluidStack drained = this.drain(itemStack, 1000, false);
        Block block = this.getFluid().getBlock();
        boolean hasBucket = drained != null && drained.amount == 1000;
        boolean hasSpace = fluidStack == null || fluidStack.amount + 1000 <= this.getCapacity(itemStack);
        MovingObjectPosition movingobjectpositionDrain = this.func_77621_a(world, player, false);
        MovingObjectPosition movingobjectpositionFill = this.func_77621_a(world, player, true);
        if (movingobjectpositionDrain != null && movingobjectpositionFill != null) {
            BlockPos blockPos;
            if (this.isPickupFluids() && movingobjectpositionFill.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                blockPos = movingobjectpositionFill.func_178782_a();
                if (!world.canMineBlockBody(player, blockPos)) {
                    return itemStack;
                }
                if (world.func_180495_p(blockPos).func_177230_c() == block && (Integer)world.func_180495_p(blockPos).func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                    if (hasSpace) {
                        world.func_175698_g(blockPos);
                        this.fill(itemStack, new FluidStack(this.getFluid(), 1000), true);
                    }
                    return itemStack;
                }
            }
            if (hasBucket && this.isPlaceFluids() && movingobjectpositionDrain.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                blockPos = movingobjectpositionFill.func_178782_a();
                if (!world.canMineBlockBody(player, blockPos)) {
                    return itemStack;
                }
                EnumFacing direction = movingobjectpositionDrain.field_178784_b;
                if (this.tryPlaceContainedLiquid(world, blockPos = blockPos.func_177971_a(direction.func_176730_m()), block, true)) {
                    this.drain(itemStack, 1000, true);
                    return itemStack;
                }
            }
        }
        return itemStack;
    }

    private boolean tryPlaceContainedLiquid(World world, BlockPos blockPos, Block block, boolean hasBucket) {
        if (!hasBucket) {
            return false;
        }
        Material material = world.func_180495_p(blockPos).func_177230_c().func_149688_o();
        if (!world.func_175623_d(blockPos) && material.func_76220_a()) {
            return false;
        }
        if (!(world.field_72995_K || material.func_76220_a() || material.func_76224_d())) {
            world.func_175655_b(blockPos, true);
        }
        world.func_180501_a(blockPos, block.func_176223_P(), 3);
        return true;
    }

    public boolean func_82788_x() {
        return true;
    }

    public boolean isPlaceFluids() {
        return this.placeFluids;
    }

    public boolean isPickupFluids() {
        return this.canPickUp;
    }

    public void setPlaceFluids(boolean placeFluids) {
        this.placeFluids = placeFluids;
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, BlockPos blockPos, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean doesSneakBypassUse(World world, BlockPos blockPos, EntityPlayer player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        L10NHelpers.addOptionalInfo(list, this.func_77658_a());
        super.func_77624_a(itemStack, entityPlayer, list, par4);
    }

    protected FluidStack drainFromOthers(int amount, ItemStack itemStack, Fluid fluid, EntityPlayer player, boolean doDrain) {
        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
        FluidStack drained = null;
        while (it.hasNext() && amount > 0) {
            FluidStack thisDrained;
            ItemStack current = it.next();
            if (current == null || current == itemStack || !(current.func_77973_b() instanceof IFluidContainerItem) || (thisDrained = ((IFluidContainerItem)current.func_77973_b()).drain(current, amount, doDrain)) == null || thisDrained.getFluid() != fluid) continue;
            if (drained == null) {
                drained = thisDrained;
            } else {
                drained.amount += drained.amount;
            }
            amount -= drained.amount;
        }
        return drained;
    }

    public boolean canConsume(int amount, ItemStack itemStack, EntityPlayer player) {
        if (this.canDrain(amount, itemStack)) {
            return true;
        }
        int availableAmount = 0;
        if (this.getFluid(itemStack) != null) {
            availableAmount = this.getFluid((ItemStack)itemStack).amount;
        }
        return this.drainFromOthers(amount - availableAmount, itemStack, this.getFluid(), player, false) != null;
    }

    public FluidStack consume(int amount, ItemStack itemStack, EntityPlayer player) {
        boolean doDrain;
        boolean bl = doDrain = !player.field_71075_bZ.field_75098_d && !player.field_70170_p.field_72995_K;
        if (amount == 0) {
            return null;
        }
        FluidStack drained = this.drain(itemStack, amount, doDrain);
        if (drained != null && drained.amount == amount) {
            return drained;
        }
        int drainedAmount = drained == null ? 0 : drained.amount;
        int toDrain = amount - drainedAmount;
        FluidStack otherDrained = this.drainFromOthers(toDrain, itemStack, this.getFluid(), player, doDrain);
        if (otherDrained == null) {
            return drained;
        }
        otherDrained.amount += drainedAmount;
        return otherDrained;
    }
}

