/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurable;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipeList;
import org.cyclops.cyclopscore.config.configurable.IConfigurable;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.VillagerConfig;
import org.cyclops.cyclopscore.item.WeightedItemStack;

public class ConfigurableVillager
implements IConfigurable {
    protected ExtendedConfig<VillagerConfig> eConfig = null;
    protected List<WeightedItemStack> allowedTradeInputs = new ArrayList<WeightedItemStack>();
    protected List<WeightedItemStack> allowedTradeOutputs = new ArrayList<WeightedItemStack>();
    protected int maxWeightDifference = 25;
    protected int inputMinStackSize = 1;
    protected int inputMaxStackSize = 64;
    protected int addedRecipes = 0;
    protected int requiredAddedRecipes = 10;
    private int attemptAddRecipeUpperbound = 100;
    private int attemptAddRecipe = 0;

    protected ConfigurableVillager(ExtendedConfig eConfig) {
        this.setConfig(eConfig);
    }

    private void setConfig(ExtendedConfig eConfig) {
        this.eConfig = eConfig;
    }

    @Override
    public ExtendedConfig<?> getConfig() {
        return this.eConfig;
    }

    private boolean tryAddingRecipe(MerchantRecipeList recipeList, Random random, WeightedItemStack inputAWeighted, WeightedItemStack inputBWeighted, WeightedItemStack outputWeighted) {
        ++this.attemptAddRecipe;
        int inputWeight = inputAWeighted.getWeight() * 64;
        inputWeight = inputBWeighted != null ? (inputWeight += inputBWeighted.getWeight() * 64) : (inputWeight *= 2);
        if (outputWeighted.getWeight() - inputWeight >= this.maxWeightDifference) {
            if (inputBWeighted == null) {
                return false;
            }
            inputWeight -= inputBWeighted.getWeight() * 64;
            inputBWeighted = null;
            if (Math.abs(outputWeighted.getWeight() - inputWeight) >= this.maxWeightDifference) {
                return false;
            }
        }
        int totalInputWeight = 0;
        ItemStack inputA = inputAWeighted.getItemStack().func_77946_l();
        inputA.field_77994_a = this.getRandomBetween(random, inputA.field_77994_a, this.getRandomBetween(random, this.inputMinStackSize, this.inputMaxStackSize));
        if (inputA.field_77994_a > inputA.func_77976_d()) {
            inputA.field_77994_a = inputA.func_77976_d();
        }
        totalInputWeight += inputA.field_77994_a * inputAWeighted.getWeight() / inputAWeighted.getItemStack().field_77994_a;
        if (inputBWeighted != null) {
            ItemStack inputB = inputAWeighted.getItemStack().func_77946_l();
            inputB.field_77994_a = this.getRandomBetween(random, inputB.field_77994_a, this.getRandomBetween(random, this.inputMinStackSize, this.inputMaxStackSize));
            if (inputB.field_77994_a > inputB.func_77976_d()) {
                inputB.field_77994_a = inputB.func_77976_d();
            }
            totalInputWeight += inputB.field_77994_a * inputBWeighted.getWeight() / inputBWeighted.getItemStack().field_77994_a;
        } else {
            Object inputB = null;
        }
        ItemStack output = outputWeighted.getItemStack().func_77946_l();
        output.field_77994_a = Math.min(64, outputWeighted.getItemStack().field_77994_a * (int)this.safeDivide(totalInputWeight, outputWeighted.getWeight()));
        if (output.field_77994_a == 0) {
            return false;
        }
        if (output.field_77994_a > output.func_77976_d()) {
            output.field_77994_a = output.func_77976_d();
        }
        ++this.addedRecipes;
        return true;
    }

    protected float safeDivide(int i, float j) {
        return (float)i / Math.max(1.0f, j);
    }

    protected WeightedItemStack getRandomWeightedItemStack(List<WeightedItemStack> trades, Random random) {
        return trades.get(random.nextInt(trades.size()));
    }

    protected WeightedItemStack getRandomInput(Random random) {
        return this.getRandomWeightedItemStack(this.allowedTradeInputs, random);
    }

    protected WeightedItemStack getRandomOutput(Random random) {
        return this.getRandomWeightedItemStack(this.allowedTradeOutputs, random);
    }

    protected int getRandomBetween(Random random, int min, int max) {
        return min + random.nextInt(max - min + 1);
    }
}

