/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class BlockFluidConfig
extends BlockConfig {
    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation fluidLocation;

    public BlockFluidConfig(ModBase mod, boolean enabled, String namedId, String comment, Class<? extends BlockFluidClassic> element) {
        super(mod, enabled, namedId, comment, (Class<? extends Block>)element);
        if (MinecraftHelpers.isClientSide()) {
            this.fluidLocation = new ModelResourceLocation(mod.getModId() + ":" + this.getNamedId(), "fluid");
        }
    }

    public BlockFluidClassic getBlockInstance() {
        return (BlockFluidClassic)super.getBlockInstance();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRegistered() {
        super.onRegistered();
        BlockFluidClassic blockInstance = this.getBlockInstance();
        Item fluid = Item.func_150898_a((Block)blockInstance);
        ModelBakery.addVariantName((Item)fluid, (String[])new String[0]);
        ModelLoader.setCustomMeshDefinition((Item)fluid, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return BlockFluidConfig.this.fluidLocation;
            }
        });
        ModelLoader.setCustomStateMapper((Block)blockInstance, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return BlockFluidConfig.this.fluidLocation;
            }
        });
    }
}

