/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.item.IBucketRegistry;

public abstract class ItemBucketConfig
extends ItemConfig {
    public ItemBucketConfig(ModBase mod, boolean enabled, String namedId, String comment, Class<? extends Item> element) {
        super(mod, enabled, namedId, comment, element);
    }

    @Override
    public String getUnlocalizedName() {
        return "items." + this.getMod().getModId() + "." + this.getNamedId();
    }

    public abstract Fluid getFluidInstance();

    public abstract Block getFluidBlockInstance();

    @Override
    public void onRegistered() {
        Item item = (Item)this.getSubInstance();
        IBucketRegistry bucketRegistry = this.getMod().getRegistryManager().getRegistry(IBucketRegistry.class);
        if (bucketRegistry != null) {
            if (this.getFluidInstance() != null) {
                FluidStack fluidStack = FluidRegistry.getFluidStack((String)this.getFluidInstance().getName(), (int)1000);
                FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)new ItemStack(item), (ItemStack)new ItemStack(item.func_77668_q()));
                bucketRegistry.registerBucket(item, fluidStack);
            }
            if (this.getFluidBlockInstance() != Blocks.field_150350_a) {
                bucketRegistry.registerBucket(this.getFluidBlockInstance(), item);
            }
        }
    }

    @Override
    public boolean isDisableable() {
        return false;
    }
}

