/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.datastructure;

import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class DimPos
implements Comparable<DimPos> {
    private final World world;
    private final BlockPos blockPos;

    @Override
    public int compareTo(DimPos o) {
        int compareDim = Integer.compare(this.getWorld().field_73011_w.func_177502_q(), o.getWorld().field_73011_w.func_177502_q());
        if (compareDim == 0) {
            return MinecraftHelpers.compareBlockPos(this.getBlockPos(), o.getBlockPos());
        }
        return compareDim;
    }

    private DimPos(World world, BlockPos blockPos) {
        this.world = world;
        this.blockPos = blockPos;
    }

    public static DimPos of(World world, BlockPos blockPos) {
        return new DimPos(world, blockPos);
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DimPos)) {
            return false;
        }
        DimPos other = (DimPos)o;
        if (!other.canEqual(this)) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        BlockPos this$blockPos = this.getBlockPos();
        BlockPos other$blockPos = other.getBlockPos();
        return !(this$blockPos == null ? other$blockPos != null : !this$blockPos.equals(other$blockPos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DimPos;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        World $world = this.getWorld();
        result = result * 59 + ($world == null ? 0 : $world.hashCode());
        BlockPos $blockPos = this.getBlockPos();
        result = result * 59 + ($blockPos == null ? 0 : $blockPos.hashCode());
        return result;
    }

    public String toString() {
        return "DimPos(world=" + this.getWorld() + ", blockPos=" + this.getBlockPos() + ")";
    }
}

