/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public final class BlockHelpers {
    public static <T> T getSafeBlockStateProperty(@Nullable IBlockState state, IProperty property, T fallback) {
        if (state == null) {
            return fallback;
        }
        Comparable value = state.func_177229_b(property);
        if (value == null) {
            return fallback;
        }
        return (T)value;
    }

    public static <T> T getSafeBlockStateProperty(@Nullable IExtendedBlockState state, IUnlistedProperty<T> property, T fallback) {
        if (state == null) {
            return fallback;
        }
        Object value = state.getValue(property);
        if (value == null) {
            return fallback;
        }
        return (T)value;
    }

    public static Pair<String, Integer> serializeBlockState(IBlockState blockState) {
        String blockName = Block.field_149771_c.func_177774_c((Object)blockState.func_177230_c()).toString();
        int meta = blockState.func_177230_c().func_176201_c(blockState);
        return Pair.of((Object)blockName, (Object)meta);
    }

    public static IBlockState deserializeBlockState(Pair<String, Integer> serializedBlockState) {
        Block block = Block.func_149684_b((String)((String)serializedBlockState.getLeft()));
        if (block != null) {
            return block.func_176203_a(((Integer)serializedBlockState.getRight()).intValue());
        }
        return null;
    }

    public static IBlockState getBlockStateFromItemStack(ItemStack itemStack) {
        Block block = ((ItemBlock)itemStack.func_77973_b()).func_179223_d();
        return block.func_176203_a(itemStack.func_77960_j());
    }

    public static ItemStack getItemStackFromBlockState(IBlockState blockState) {
        Item item = Item.func_150898_a((Block)blockState.func_177230_c());
        return new ItemStack(item, 1, blockState.func_177230_c().func_176201_c(blockState));
    }
}

