/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.init.ModBase;

public class Helpers {
    private static Map<Pair<ModBase, IDType>, Integer> ID_COUNTER = new HashMap<Pair<ModBase, IDType>, Integer>();

    public static Object tryParse(String newValue, Object oldValue) {
        Object newValueParsed = null;
        try {
            if (oldValue instanceof Integer) {
                newValueParsed = Integer.parseInt(newValue);
            } else if (oldValue instanceof Boolean) {
                newValueParsed = Boolean.parseBoolean(newValue);
            } else if (oldValue instanceof Double) {
                newValueParsed = Double.parseDouble(newValue);
            } else if (oldValue instanceof String) {
                newValueParsed = newValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newValueParsed;
    }

    public static int getNewId(ModBase mod, IDType type) {
        Integer ID = ID_COUNTER.get(Pair.of((Object)mod, (Object)((Object)type)));
        if (ID == null) {
            ID = 0;
        }
        ID_COUNTER.put((Pair<ModBase, IDType>)Pair.of((Object)mod, (Object)((Object)type)), ID + 1);
        return ID;
    }

    public static int RGBToInt(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public static Triple<Float, Float, Float> intToRGB(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return Triple.of((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
    }

    public static enum IDType {
        ENTITY,
        GUI,
        PACKET;

    }
}

