/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderHelpers {
    private static final Random rand = new Random();

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static void drawScaledCenteredString(FontRenderer fontRenderer, String string, int x, int y, int maxWidth, int color) {
        RenderHelpers.drawScaledCenteredString(fontRenderer, string, x, y, maxWidth, 1.0f, maxWidth, color);
    }

    public static void drawScaledCenteredString(FontRenderer fontRenderer, String string, int x, int y, int width, float originalScale, int maxWidth, int color) {
        float originalWidth = (float)fontRenderer.func_78256_a(string) * originalScale;
        float scale = Math.min(originalScale, (float)maxWidth / originalWidth * originalScale);
        RenderHelpers.drawScaledCenteredString(fontRenderer, string, x, y, width, scale, color);
    }

    public static void drawScaledCenteredString(FontRenderer fontRenderer, String string, int x, int y, int width, float scale, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        int titleLength = fontRenderer.func_78256_a(string);
        int titleHeight = fontRenderer.field_78288_b;
        fontRenderer.func_78276_b(string, Math.round((float)(x + width / 2) / scale - (float)(titleLength / 2)), Math.round((float)y / scale - (float)(titleHeight / 2)), color);
        GlStateManager.func_179121_F();
    }

    public static IBakedModel getBakedModel(IBlockState blockState) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174954_c().func_178125_b(blockState);
    }

    public static void addBlockHitEffects(EffectRenderer effectRenderer, World world, IBlockState blockState, BlockPos pos, EnumFacing side) {
        Block block = blockState.func_177230_c();
        if (block.func_149645_b() != -1) {
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            float f = 0.1f;
            double d0 = (double)i + rand.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(f * 2.0f)) + (double)f + block.func_149704_x();
            double d1 = (double)j + rand.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(f * 2.0f)) + (double)f + block.func_149665_z();
            double d2 = (double)k + rand.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(f * 2.0f)) + (double)f + block.func_149706_B();
            if (side == EnumFacing.DOWN) {
                d1 = (double)j + block.func_149665_z() - (double)f;
            }
            if (side == EnumFacing.UP) {
                d1 = (double)j + block.func_149669_A() + (double)f;
            }
            if (side == EnumFacing.NORTH) {
                d2 = (double)k + block.func_149706_B() - (double)f;
            }
            if (side == EnumFacing.SOUTH) {
                d2 = (double)k + block.func_149693_C() + (double)f;
            }
            if (side == EnumFacing.WEST) {
                d0 = (double)i + block.func_149704_x() - (double)f;
            }
            if (side == EnumFacing.EAST) {
                d0 = (double)i + block.func_149753_y() + (double)f;
            }
            EntityFX fx = new EntityDiggingFX.Factory().func_178902_a(-1, world, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)blockState)});
            effectRenderer.func_78873_a(fx);
        }
    }
}

