/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.init;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.RecipeSorter;
import org.cyclops.cyclopscore.GeneralConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.recipe.event.ObservableShapedRecipe;
import org.cyclops.cyclopscore.recipe.event.ObservableShapelessRecipe;
import org.cyclops.cyclopscore.recipe.xml.ConfigRecipeConditionHandler;
import org.cyclops.cyclopscore.recipe.xml.IRecipeConditionHandler;
import org.cyclops.cyclopscore.recipe.xml.IRecipeTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.ModRecipeConditionHandler;
import org.cyclops.cyclopscore.recipe.xml.PredefinedRecipeConditionHandler;
import org.cyclops.cyclopscore.recipe.xml.ShapedRecipeTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.ShapelessRecipeTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.SmeltingRecipeTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.XmlRecipeLoader;

public class RecipeHandler {
    private final Multimap<String, ItemStack> taggedOutput = LinkedListMultimap.create();
    private final Multimap<String, ExtendedConfig<?>> taggedConfigurablesOutput = LinkedListMultimap.create();
    private final Map<String, IRecipeTypeHandler> recipeTypeHandlers = Maps.newHashMap();
    private final Map<String, IRecipeConditionHandler> recipeConditionHandlers = Maps.newHashMap();
    private final Map<String, ItemStack> predefinedItems = Maps.newHashMap();
    private final Set<String> predefinedValues = Sets.newHashSet();
    private final ModBase mod;
    private final List<String> recipeFiles;
    private final AtomicReference<Object> externalRecipesPattern = new AtomicReference();

    public RecipeHandler(ModBase mod, String ... fileNames) {
        this.mod = mod;
        this.recipeFiles = Lists.newArrayList((Object[])fileNames);
        this.registerHandlers(this.recipeTypeHandlers, this.recipeConditionHandlers);
    }

    protected void registerHandlers(Map<String, IRecipeTypeHandler> recipeTypeHandlers, Map<String, IRecipeConditionHandler> recipeConditionHandlers) {
        recipeTypeHandlers.put("shaped", new ShapedRecipeTypeHandler());
        recipeTypeHandlers.put("shapeless", new ShapelessRecipeTypeHandler());
        recipeTypeHandlers.put("smelting", new SmeltingRecipeTypeHandler());
        recipeConditionHandlers.put("config", new ConfigRecipeConditionHandler());
        recipeConditionHandlers.put("predefined", new PredefinedRecipeConditionHandler());
        recipeConditionHandlers.put("mod", new ModRecipeConditionHandler());
    }

    protected XmlRecipeLoader constructXmlRecipeLoader(InputStream is, String fileName) {
        return new XmlRecipeLoader(this.getMod(), is, fileName, this);
    }

    protected void registerRecipesForFile(InputStream is, String fileName) throws XmlRecipeLoader.XmlRecipeException {
        InputStream xsdIs = RecipeHandler.class.getResourceAsStream(this.getRecipesXsdPath());
        XmlRecipeLoader loader = this.constructXmlRecipeLoader(is, fileName);
        loader.setValidator(xsdIs);
        loader.loadRecipes(GeneralConfig.crashOnInvalidRecipe);
    }

    protected void registerRecipesForFiles(File file) throws XmlRecipeLoader.XmlRecipeException {
        File[] childFiles;
        if (file.isFile() && this.getExternalRecipesPattern().matcher(file.getName()).matches()) {
            try {
                this.registerRecipesForFile(new FileInputStream(file), file.getName());
            }
            catch (FileNotFoundException e) {}
        } else if (file.isDirectory() && (childFiles = file.listFiles()) != null) {
            for (File childFile : childFiles) {
                this.registerRecipesForFiles(childFile);
            }
        }
    }

    protected String getRecipesBasePath() {
        return "/assets/" + this.getMod().getModId() + "/recipes/";
    }

    protected String getRecipesXsdPath() {
        return "/assets/cyclopscore/recipes/recipes.xsd";
    }

    public final void registerRecipes(File rootConfigFolder) throws XmlRecipeLoader.XmlRecipeException {
        this.registerRecipeSorters();
        this.loadPredefineds(this.getPredefinedItems(), this.getPredefinedValues());
        for (String file : this.getRecipeFiles()) {
            InputStream is = RecipeHandler.class.getResourceAsStream(this.getRecipesBasePath() + file);
            this.registerRecipesForFile(is, file);
        }
        if (rootConfigFolder.exists()) {
            this.registerRecipesForFiles(rootConfigFolder);
        }
        this.registerCustomRecipes();
    }

    protected void registerRecipeSorters() {
        RecipeSorter.register((String)(this.getMod().getModId() + "observableshapeless"), ObservableShapelessRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
        RecipeSorter.register((String)(this.getMod().getModId() + "observableshaped"), ObservableShapedRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapedore");
    }

    protected void loadPredefineds(Map<String, ItemStack> predefinedItems, Set<String> predefinedValues) {
    }

    protected void registerCustomRecipes() {
    }

    public ItemStack getPredefinedItem(String key) {
        return this.predefinedItems.get(key);
    }

    public boolean isPredefinedValue(String value) {
        return this.predefinedValues.contains(value);
    }

    public Multimap<String, ItemStack> getTaggedOutput() {
        return this.taggedOutput;
    }

    public Multimap<String, ExtendedConfig<?>> getTaggedConfigurablesOutput() {
        return this.taggedConfigurablesOutput;
    }

    public Map<String, IRecipeTypeHandler> getRecipeTypeHandlers() {
        return this.recipeTypeHandlers;
    }

    public Map<String, IRecipeConditionHandler> getRecipeConditionHandlers() {
        return this.recipeConditionHandlers;
    }

    public Map<String, ItemStack> getPredefinedItems() {
        return this.predefinedItems;
    }

    public Set<String> getPredefinedValues() {
        return this.predefinedValues;
    }

    public ModBase getMod() {
        return this.mod;
    }

    public List<String> getRecipeFiles() {
        return this.recipeFiles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeHandler)) {
            return false;
        }
        RecipeHandler other = (RecipeHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Multimap<String, ItemStack> this$taggedOutput = this.getTaggedOutput();
        Multimap<String, ItemStack> other$taggedOutput = other.getTaggedOutput();
        if (this$taggedOutput == null ? other$taggedOutput != null : !this$taggedOutput.equals(other$taggedOutput)) {
            return false;
        }
        Multimap<String, ExtendedConfig<?>> this$taggedConfigurablesOutput = this.getTaggedConfigurablesOutput();
        Multimap<String, ExtendedConfig<?>> other$taggedConfigurablesOutput = other.getTaggedConfigurablesOutput();
        if (this$taggedConfigurablesOutput == null ? other$taggedConfigurablesOutput != null : !this$taggedConfigurablesOutput.equals(other$taggedConfigurablesOutput)) {
            return false;
        }
        Map<String, IRecipeTypeHandler> this$recipeTypeHandlers = this.getRecipeTypeHandlers();
        Map<String, IRecipeTypeHandler> other$recipeTypeHandlers = other.getRecipeTypeHandlers();
        if (this$recipeTypeHandlers == null ? other$recipeTypeHandlers != null : !((Object)this$recipeTypeHandlers).equals(other$recipeTypeHandlers)) {
            return false;
        }
        Map<String, IRecipeConditionHandler> this$recipeConditionHandlers = this.getRecipeConditionHandlers();
        Map<String, IRecipeConditionHandler> other$recipeConditionHandlers = other.getRecipeConditionHandlers();
        if (this$recipeConditionHandlers == null ? other$recipeConditionHandlers != null : !((Object)this$recipeConditionHandlers).equals(other$recipeConditionHandlers)) {
            return false;
        }
        Map<String, ItemStack> this$predefinedItems = this.getPredefinedItems();
        Map<String, ItemStack> other$predefinedItems = other.getPredefinedItems();
        if (this$predefinedItems == null ? other$predefinedItems != null : !((Object)this$predefinedItems).equals(other$predefinedItems)) {
            return false;
        }
        Set<String> this$predefinedValues = this.getPredefinedValues();
        Set<String> other$predefinedValues = other.getPredefinedValues();
        if (this$predefinedValues == null ? other$predefinedValues != null : !((Object)this$predefinedValues).equals(other$predefinedValues)) {
            return false;
        }
        ModBase this$mod = this.getMod();
        ModBase other$mod = other.getMod();
        if (this$mod == null ? other$mod != null : !((Object)this$mod).equals(other$mod)) {
            return false;
        }
        List<String> this$recipeFiles = this.getRecipeFiles();
        List<String> other$recipeFiles = other.getRecipeFiles();
        if (this$recipeFiles == null ? other$recipeFiles != null : !((Object)this$recipeFiles).equals(other$recipeFiles)) {
            return false;
        }
        Pattern this$externalRecipesPattern = this.getExternalRecipesPattern();
        Pattern other$externalRecipesPattern = other.getExternalRecipesPattern();
        return !(this$externalRecipesPattern == null ? other$externalRecipesPattern != null : !this$externalRecipesPattern.equals(other$externalRecipesPattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecipeHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Multimap<String, ItemStack> $taggedOutput = this.getTaggedOutput();
        result = result * 59 + ($taggedOutput == null ? 0 : $taggedOutput.hashCode());
        Multimap<String, ExtendedConfig<?>> $taggedConfigurablesOutput = this.getTaggedConfigurablesOutput();
        result = result * 59 + ($taggedConfigurablesOutput == null ? 0 : $taggedConfigurablesOutput.hashCode());
        Map<String, IRecipeTypeHandler> $recipeTypeHandlers = this.getRecipeTypeHandlers();
        result = result * 59 + ($recipeTypeHandlers == null ? 0 : ((Object)$recipeTypeHandlers).hashCode());
        Map<String, IRecipeConditionHandler> $recipeConditionHandlers = this.getRecipeConditionHandlers();
        result = result * 59 + ($recipeConditionHandlers == null ? 0 : ((Object)$recipeConditionHandlers).hashCode());
        Map<String, ItemStack> $predefinedItems = this.getPredefinedItems();
        result = result * 59 + ($predefinedItems == null ? 0 : ((Object)$predefinedItems).hashCode());
        Set<String> $predefinedValues = this.getPredefinedValues();
        result = result * 59 + ($predefinedValues == null ? 0 : ((Object)$predefinedValues).hashCode());
        ModBase $mod = this.getMod();
        result = result * 59 + ($mod == null ? 0 : ((Object)$mod).hashCode());
        List<String> $recipeFiles = this.getRecipeFiles();
        result = result * 59 + ($recipeFiles == null ? 0 : ((Object)$recipeFiles).hashCode());
        Pattern $externalRecipesPattern = this.getExternalRecipesPattern();
        result = result * 59 + ($externalRecipesPattern == null ? 0 : $externalRecipesPattern.hashCode());
        return result;
    }

    public String toString() {
        return "RecipeHandler(taggedOutput=" + this.getTaggedOutput() + ", taggedConfigurablesOutput=" + this.getTaggedConfigurablesOutput() + ", recipeTypeHandlers=" + this.getRecipeTypeHandlers() + ", recipeConditionHandlers=" + this.getRecipeConditionHandlers() + ", predefinedItems=" + this.getPredefinedItems() + ", predefinedValues=" + this.getPredefinedValues() + ", mod=" + this.getMod() + ", recipeFiles=" + this.getRecipeFiles() + ", externalRecipesPattern=" + this.getExternalRecipesPattern() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern getExternalRecipesPattern() {
        Object value = this.externalRecipesPattern.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.externalRecipesPattern;
            synchronized (atomicReference) {
                value = this.externalRecipesPattern.get();
                if (value == null) {
                    Pattern actualValue = Pattern.compile("^[^_].*\\.xml");
                    value = actualValue == null ? this.externalRecipesPattern : actualValue;
                    this.externalRecipesPattern.set(value);
                }
            }
        }
        return (Pattern)(value == this.externalRecipesPattern ? null : value);
    }
}

