/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.client.gui.GuiHandler;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;

public abstract class ItemGui
extends ConfigurableItem
implements IGuiContainerProvider {
    private int guiID;

    protected ItemGui(ExtendedConfig eConfig) {
        super(eConfig);
        this.guiID = Helpers.getNewId(eConfig.getMod(), Helpers.IDType.GUI);
    }

    @Override
    public ModBase getMod() {
        return this.eConfig.getMod();
    }

    @Override
    public int getGuiID() {
        return this.guiID;
    }

    @Override
    public abstract Class<? extends Container> getContainer();

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract Class<? extends GuiScreen> getGui();

    public boolean onDroppedByPlayer(ItemStack itemstack, EntityPlayer player) {
        if (itemstack != null && player instanceof EntityPlayerMP && player.field_71070_bA != null && player.field_71070_bA.getClass() == this.getContainer()) {
            player.func_71053_j();
        }
        return super.onDroppedByPlayer(itemstack, player);
    }

    public void openGuiForItemIndex(World world, EntityPlayer player, int itemIndex) {
        this.getConfig().getMod().getGuiHandler().setTemporaryData(GuiHandler.GuiType.ITEM, itemIndex);
        if (!world.field_72995_K || this.isClientSideOnlyGui()) {
            player.openGui((Object)this.getConfig().getMod(), this.getGuiID(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    protected boolean isClientSideOnlyGui() {
        return false;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        this.openGuiForItemIndex(world, player, player.field_71071_by.field_70461_c);
        return itemStack;
    }
}

