/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.modcompat.IModCompat;

public class ModCompatLoader
implements IInitListener {
    private static final String CONFIG_CATEGORY = "mod compat";
    protected final ModBase mod;
    protected final List<IModCompat> modCompats = Lists.newLinkedList();
    protected final Set<String> crashedModcompats = Sets.newHashSet();

    public ModCompatLoader(ModBase mod) {
        this.mod = mod;
    }

    public void addModCompat(IModCompat modCompat) {
        this.modCompats.add(modCompat);
    }

    @Override
    public void onInit(IInitListener.Step step) {
        if (step == IInitListener.Step.PREINIT && !this.modCompats.isEmpty()) {
            this.mod.getConfigHandler().addCategory(CONFIG_CATEGORY);
        }
        for (IModCompat modCompat : this.modCompats) {
            if (!this.shouldLoadModCompat(modCompat)) continue;
            try {
                modCompat.onInit(step);
            }
            catch (RuntimeException e) {
                this.mod.log(Level.ERROR, "The mod compatibility for " + modCompat.getModID() + " has crashed! Report this crash clog to the mod author or try updating the conflicting mods.");
                if (this.mod.getReferenceValue(ModBase.REFKEY_CRASH_ON_MODCOMPAT_CRASH).booleanValue()) {
                    throw e;
                }
                e.printStackTrace();
                this.crashedModcompats.add(modCompat.getModID());
            }
        }
    }

    public boolean shouldLoadModCompat(IModCompat modCompat) {
        return this.isModLoaded(modCompat) && this.isModEnabled(modCompat) && this.isModNotCrashed(modCompat);
    }

    private boolean isModLoaded(IModCompat modCompat) {
        return Loader.isModLoaded((String)modCompat.getModID());
    }

    private boolean isModEnabled(IModCompat modCompat) {
        Configuration config = this.mod.getConfigHandler().getConfig();
        Property property = config.get(CONFIG_CATEGORY, modCompat.getModID(), modCompat.isEnabled());
        property.setRequiresMcRestart(true);
        property.comment = modCompat.getComment();
        boolean enabled = property.getBoolean(true);
        if (config.hasChanged()) {
            config.save();
        }
        return enabled;
    }

    private boolean isModNotCrashed(IModCompat modCompat) {
        return !this.crashedModcompats.contains(modCompat.getModID());
    }
}

